uniform sampler2D texture;

varying vec3 normal, light_vector;
varying vec4 xd;
varying vec2 texcoord;

void main(){
	vec4 color=vec4(0.0,0.0,0.0,0.0);
	float diff_int, spec_int;
	diff_int=max(0.0,dot(normalize(normal),normalize(light_vector)));
	spec_int=max(0.0,dot(normalize(normal),normalize(normalize(light_vector)+normalize(xd.xyz))));
	if (gl_FrontMaterial.specular.w==0.0){
		color=gl_FrontMaterial.emission+gl_LightModel.ambient*texture2D(texture,texcoord);
		color+=texture2D(texture,texcoord)*gl_LightSource[0].diffuse*diff_int;
	}
	else{
		color=gl_FrontMaterial.emission+gl_LightModel.ambient*gl_FrontMaterial.ambient;
		color+=gl_FrontMaterial.diffuse*gl_LightSource[0].diffuse*diff_int;
	}
	if (diff_int>0.0) color+=gl_LightSource[0].specular*pow(spec_int,gl_FrontMaterial.shininess)*gl_FrontMaterial.shininess/128.0;
	color[3]=1.0;
	gl_FragColor=color;
}
