//depth of field
varying float Blur;
varying float depth_z;
//texturing
uniform sampler2D Texture0,Texture1;
uniform float timer;

//ljus
varying vec4 in_diffuse,in_ambientGlobal,in_ambient;
varying vec3 in_normal,in_lightDir,in_halfVector;
varying float in_dist;

float noise(vec2 pos,int seed) {
	float ret = fract(sin(seed+dot(pos,vec2(12.9898,78.233)))*43758.5453)*2.0-0.8;
	return ret;
}



void main (void) {
		vec4 final,base;
		float att;
		base = gl_Color;
		vec3 n,halfV,viewV,ldir;
		float NdotL,NdotHV;
		final = in_ambientGlobal;


			n = normalize(in_normal);
			NdotL = max(dot(n,normalize(in_lightDir)),0.0);
	
			if (NdotL > 0.0) {
				att = 1.0 / (gl_LightSource[0].constantAttenuation 
						+ gl_LightSource[0].linearAttenuation * in_dist 
						+ gl_LightSource[0].quadraticAttenuation * in_dist * in_dist);
				halfV = normalize(in_halfVector);
				NdotHV = max(dot(n,halfV),0.0);
				vec4 vSpecular = att * gl_FrontMaterial.specular * gl_LightSource[0].specular * pow(NdotHV,gl_FrontMaterial.shininess);
				final = att * (in_ambientGlobal+in_diffuse*base*NdotL) + vSpecular;
			}			
	

	final.a = Blur;

	/*
	if(base.xyz == vec3(0.1337,0.1337,0.1337)) {
		final = vec4(0.0,1.0,0.0,1.0);;
	}
	*/

	gl_FragData[0] = final;
	gl_FragData[1].xyz = vec3(depth_z,depth_z,depth_z);
}

