//depth of field
varying float Blur;
varying float Depth;
//texturing
uniform sampler2D Texture0,Texture1;

//config
uniform int config;
/*
denna variabel sätter hur shadern skall arbeta
0 = normal ljussättning med glColor3f 
1 = bara färgtextur
2 = färgtextur + bumpmappning
*/


//ljus
varying vec4 in_diffuse,in_ambientGlobal,in_ambient;
varying vec3 in_normal,in_lightDir,in_halfVector;
varying float in_dist;


//normalMapping
varying vec3 lightVec;
varying vec3 eyeVec;
varying vec2 texCoord;
uniform float invRadius;

void main (void) {
		vec4 final,base;
		float distSqr = dot(lightVec, lightVec);
		float att = clamp(1.0 - invRadius * sqrt(distSqr), 0.0, 1.0);
		vec3 lVec = lightVec * inversesqrt(distSqr);
		vec3 vVec = normalize(eyeVec);

		//ljus med glColor eller utan ljus
		if(config<2) {

			if(config==0) {
				base = gl_Color;
			}			
			
			if(config==1) {
				base = texture2D(Texture0, gl_TexCoord[0]);
			}

			
			vec3 n,halfV,viewV,ldir;
			float NdotL,NdotHV;
			final = in_ambientGlobal;
		
			n = normalize(in_normal);
			NdotL = max(dot(n,normalize(in_lightDir)),0.0);
	
			//if (NdotL > 0.0) {
				att = 1.0 / (gl_LightSource[0].constantAttenuation 
						+ gl_LightSource[0].linearAttenuation * in_dist 
						+ gl_LightSource[0].quadraticAttenuation * in_dist * in_dist);
				halfV = normalize(in_halfVector);
				NdotHV = max(dot(n,halfV),0.0);
				vec4 vSpecular = att * gl_FrontMaterial.specular * gl_LightSource[0].specular * pow(NdotHV,gl_FrontMaterial.shininess);
				final = att * (in_ambientGlobal+in_diffuse*base*NdotL) + vSpecular;
			//}
			
			

		   
		   //vec4 vAmbient = gl_LightSource[0].ambient * gl_FrontMaterial.ambient;
		   //vec4 vDiffuse = gl_LightSource[0].diffuse * gl_FrontMaterial.diffuse;	
		   //vec4 vSpecular = gl_LightSource[0].specular * gl_FrontMaterial.specular;	
	      //final = att*(base*vAmbient+vDiffuse*base) + vSpecular;//att*(base*vAmbient + vDiffuse*base);// + vSpecular;
		}
		

		
		//normalt ljus med färgtextur
		if(config==2) {
			base = texture2D(Texture0, gl_TexCoord[0]);
			vec4 vAmbient = gl_LightSource[0].ambient * gl_FrontMaterial.ambient;
			vec4 vDiffuse = gl_LightSource[0].diffuse * gl_FrontMaterial.diffuse;	
			vec4 vSpecular = gl_LightSource[0].specular * gl_FrontMaterial.specular;
			final = att*(base*vAmbient+vDiffuse*base) + vSpecular;
		}
		

		
		//bumpmappat ljus
		if(config==3) {
			base = texture2D(Texture0, gl_TexCoord[0]);
			vec3 bump = normalize( texture2D(Texture1, gl_TexCoord[0]).xyz * 2.0 - 1.0);
			vec4 vAmbient = gl_LightSource[0].ambient * gl_FrontMaterial.ambient;

			float diffuse = max( dot(lVec, bump), 0.0 );
			vec4 vDiffuse = gl_LightSource[0].diffuse * gl_FrontMaterial.diffuse * diffuse;	
			
			float specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0), gl_FrontMaterial.shininess);
			vec4 vSpecular = gl_LightSource[0].specular * gl_FrontMaterial.specular * specular;

			final = att*(base*vAmbient+vDiffuse*base) + vSpecular;
		}
		

	final.a = Blur;
	//final = vec4(Depth,Depth,Depth,Blur);
	gl_FragData[0] = final;// + vec4(lcolor.xyz,Blur);

	gl_FragData[1].xyz = in_normal;
	gl_FragData[1].z = 1.0;
	gl_FragData[1].a = 1.0;
}

