varying vec3 posVS;
varying vec3 normal;
varying vec3 pos;
varying vec2 uv;

attribute vec3 va_position, va_normal;
attribute vec2 va_uv0;

uniform mat4 projectmatrix;
uniform mat4 cameramatrix;
uniform mat4 normalmatrix;
uniform float waveTime;

void main(void)
{
	vec3 pos = va_position.xyz + vec3(sin(va_position.x+va_position.z), cos(va_position.y+va_position.x), sin(va_position.z+va_position.y))*0.1;

	vec4 tposVS    = (cameramatrix * vec4(pos, 1.0));

	posVS = tposVS.xyz;

	normal = normalize(normalmatrix*vec4(va_normal.xyz,0.0)).xyz;

	pos = pos;

	uv = va_uv0;

	gl_Position = projectmatrix*tposVS;
}
