varying vec3 posVS;
varying vec3 normal;
varying vec3 pos;
varying vec2 uv;

uniform vec3 color0, color1;
uniform float flowerIntensity;
uniform float ringSize;

uniform float waveTime;

uniform float emissive;
uniform float glow;

void main(void)
{
	vec2 centerUV = uv-vec2(0.5,0.5);
	float weird = ((sin((8.0*2.0*atan(centerUV.y, centerUV.x)))*0.5+0.5)) * flowerIntensity*12.0;
	float ofs = length(centerUV);
	float intensity = (sin(ofs*3.1415*64.0*ringSize-8.0*waveTime)*cos(weird)*0.5+0.5);
	
	float multiplier = pow(abs(intensity-0.5)*2.0, 28.0);

	intensity = smoothstep(0.3,0.7, intensity);

	vec3 color = mix(color0, color1, intensity);

	color *= 0.2+0.8*multiplier;

	gl_FragData[0] = vec4(color, 1.0);
	gl_FragData[1] = vec4(normalize(normal), intensity);
	gl_FragData[2] = vec4(posVS.xyz, 0.2);
}
