#version 110

uniform sampler2D texDepth;
uniform sampler2D texColor;

uniform vec3 fk[32];
uniform float pTimer;

float deppig(float zoverw) {
	float n = 0.2; //
	float f = 1000.0;
	
	return(2.0 * n) / (f + n - zoverw * (f - n));	
}

float readDepth( in vec2 coord ) {

	return abs(deppig(texture2D( texDepth, coord ).r)); 
}

void main(void)
{
	float bl = 0.0;
	float rad=(1.0/1280.0)*.02;
	
	float noise = fract(sin(pTimer+dot( gl_TexCoord[0].st ,vec2(12.9898,78.233))) * 43758.5453)*2.0-0.8;
	int random_offset = int(mod(noise, 16.0));
	
	vec2 pos = gl_TexCoord[0].st;
	float z = readDepth(pos);
	
	for( int i=0; i<32; i++ )
	{
		vec2 pos2 = pos + (fk[i].xy*rad/(z*0.02));
		
		float z2 = readDepth(pos2);
		
		float a=clamp(z-z2, 0.8, 1.0);
		
		//bl+=a*a*5;
		bl += a*0.01;
	}

	bl = bl/32.0;

	//if (bl<2.0) bl=z;
	
//	vec3 ambientColor=vec3(0.5,0.5,0.5);
//	vec3 ambient = ambientColor* texture2D(texDepth, gl_TexCoord[0].st).xyz;
	
	//gl_FragColor = texture2D(texColor, gl_TexCoord[0].st) + vec4(ambient*float(1.0-bl/8.0), 0.0);
	
//	gl_FragColor = texture2D(texColor, gl_TexCoord[0].st) * float(1.0-bl/32.0);

	gl_FragColor = texture2D(texColor, gl_TexCoord[0].st);

//	gl_FragColor.rgba = vec4(vec3(1,1,1)*bl, 1.0);
	
// 	gl_FragColor = vec4(vec3(1,1,1)*float(1.0-bl/2.0), 1.0);
}
