uniform sampler2D texColor;
uniform sampler2D texLight;
uniform sampler2D texNormal;
uniform sampler2D texPos;

uniform float xres;
uniform float yres;

void main(void)
{
	vec3 tcolor = texture2D(texColor, gl_FragCoord.xy*vec2(xres, yres)).rgb;
	vec3 tlight = texture2D(texLight, gl_FragCoord.xy*vec2(xres, yres)).rgb;
//	float tglow = texture2D(texNormal, gl_FragCoord.xy*vec2(xres, yres)).a;
	float temissive = texture2D(texPos, gl_FragCoord.xy*vec2(xres, yres)).a;

	vec3 ambient = vec3(0.1,0.1,0.15);

	vec3 latte = tlight + ambient;

	vec4 total = vec4(tlight+ambient*tcolor+tcolor*temissive, 1.0);

	gl_FragData[0] = total;
}
