/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PLine;
import processing.core.PMatrix2D;
import processing.core.PPolygon;

public class PGraphics2D
extends PGraphics {
    PMatrix2D ctm = new PMatrix2D();
    PPolygon fpolygon;
    PPolygon spolygon;
    float[][] svertices;
    PPolygon tpolygon;
    int[] vertexOrder;
    PLine line;
    float[][] matrixStack = new float[32][6];
    int matrixStackDepth;
    DirectColorModel cm;
    MemoryImageSource mis;

    protected void allocate() {
        this.pixelCount = this.width * this.height;
        this.pixels = new int[this.pixelCount];
        if (this.primarySurface) {
            this.cm = new DirectColorModel(32, 0xFF0000, 65280, 255);
            this.mis = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
            this.mis.setFullBufferUpdates(true);
            this.mis.setAnimated(true);
            this.image = Toolkit.getDefaultToolkit().createImage(this.mis);
        }
    }

    public boolean canDraw() {
        return true;
    }

    public void beginDraw() {
        if (!this.settingsInited) {
            this.defaultSettings();
            this.fpolygon = new PPolygon(this);
            this.spolygon = new PPolygon(this);
            this.spolygon.vertexCount = 4;
            this.svertices = new float[2][];
        }
        this.resetMatrix();
        this.vertexCount = 0;
    }

    public void endDraw() {
        if (this.mis != null) {
            this.mis.newPixels(this.pixels, (ColorModel)this.cm, 0, this.width);
        }
        this.updatePixels();
    }

    public void beginShape(int n) {
        this.shape = n;
        this.vertexCount = 0;
        this.curveVertexCount = 0;
        this.fpolygon.reset(4);
        this.spolygon.reset(4);
        this.textureImage = null;
    }

    public void vertex(float f, float f2, float f3) {
        PGraphics2D.showDepthWarningXYZ("vertex");
    }

    public void vertex(float f, float f2, float f3, float f4, float f5) {
        PGraphics2D.showDepthWarningXYZ("vertex");
    }

    public void breakShape() {
        PGraphics2D.showWarning("This renderer cannot handle concave shapes or shapes with holes.");
    }

    public void endShape(int n) {
        int n2;
        if (this.ctm.isIdentity()) {
            for (n2 = 0; n2 < this.vertexCount; ++n2) {
                this.vertices[n2][18] = this.vertices[n2][0];
                this.vertices[n2][19] = this.vertices[n2][1];
            }
        } else {
            for (n2 = 0; n2 < this.vertexCount; ++n2) {
                this.vertices[n2][18] = this.ctm.multX(this.vertices[n2][0], this.vertices[n2][1]);
                this.vertices[n2][19] = this.ctm.multY(this.vertices[n2][0], this.vertices[n2][1]);
            }
        }
        this.fpolygon.texture(this.textureImage);
        this.spolygon.interpARGB = true;
        this.fpolygon.interpARGB = true;
        switch (this.shape) {
            case 2: {
                if (!this.stroke) break;
                if (this.ctm.m00 == this.ctm.m11 && this.strokeWeight == 1.0f) {
                    for (int i = 0; i < this.vertexCount; ++i) {
                        this.thin_point(this.vertices[i][18], this.vertices[i][19], this.strokeColor);
                    }
                } else {
                    for (int i = 0; i < this.vertexCount; ++i) {
                        float[] fArray = this.vertices[i];
                        this.thick_point(fArray[18], fArray[19], fArray[20], fArray[13], fArray[14], fArray[15], fArray[16]);
                    }
                }
                break;
            }
            case 4: {
                if (!this.stroke) break;
                n2 = this.shape == 4 ? 2 : 1;
                this.draw_lines(this.vertices, this.vertexCount - 1, 1, n2, 0);
                break;
            }
            case 11: {
                int n3;
                if (this.fill || this.textureImage != null) {
                    this.fpolygon.vertexCount = 3;
                    for (n3 = 1; n3 < this.vertexCount - 1; ++n3) {
                        this.fpolygon.vertices[2][3] = this.vertices[0][3];
                        this.fpolygon.vertices[2][4] = this.vertices[0][4];
                        this.fpolygon.vertices[2][5] = this.vertices[0][5];
                        this.fpolygon.vertices[2][6] = this.vertices[0][6];
                        this.fpolygon.vertices[2][18] = this.vertices[0][18];
                        this.fpolygon.vertices[2][19] = this.vertices[0][19];
                        if (this.textureImage != null) {
                            this.fpolygon.vertices[2][7] = this.vertices[0][7];
                            this.fpolygon.vertices[2][8] = this.vertices[0][8];
                        }
                        for (int i = 0; i < 2; ++i) {
                            this.fpolygon.vertices[i][3] = this.vertices[n3 + i][3];
                            this.fpolygon.vertices[i][4] = this.vertices[n3 + i][4];
                            this.fpolygon.vertices[i][5] = this.vertices[n3 + i][5];
                            this.fpolygon.vertices[i][6] = this.vertices[n3 + i][6];
                            this.fpolygon.vertices[i][18] = this.vertices[n3 + i][18];
                            this.fpolygon.vertices[i][19] = this.vertices[n3 + i][19];
                            if (this.textureImage == null) continue;
                            this.fpolygon.vertices[i][7] = this.vertices[n3 + i][7];
                            this.fpolygon.vertices[i][8] = this.vertices[n3 + i][8];
                        }
                        this.fpolygon.render();
                    }
                }
                if (!this.stroke) break;
                for (n3 = 1; n3 < this.vertexCount; ++n3) {
                    this.draw_line(this.vertices[0], this.vertices[n3]);
                }
                for (n3 = 1; n3 < this.vertexCount - 1; ++n3) {
                    this.draw_line(this.vertices[n3], this.vertices[n3 + 1]);
                }
                this.draw_line(this.vertices[this.vertexCount - 1], this.vertices[1]);
                break;
            }
            case 9: 
            case 10: {
                int n4 = n2 = this.shape == 9 ? 3 : 1;
                if (this.fill || this.textureImage != null) {
                    this.fpolygon.vertexCount = 3;
                    for (int i = 0; i < this.vertexCount - 2; i += n2) {
                        for (int j = 0; j < 3; ++j) {
                            this.fpolygon.vertices[j][3] = this.vertices[i + j][3];
                            this.fpolygon.vertices[j][4] = this.vertices[i + j][4];
                            this.fpolygon.vertices[j][5] = this.vertices[i + j][5];
                            this.fpolygon.vertices[j][6] = this.vertices[i + j][6];
                            this.fpolygon.vertices[j][18] = this.vertices[i + j][18];
                            this.fpolygon.vertices[j][19] = this.vertices[i + j][19];
                            this.fpolygon.vertices[j][20] = this.vertices[i + j][20];
                            if (this.textureImage == null) continue;
                            this.fpolygon.vertices[j][7] = this.vertices[i + j][7];
                            this.fpolygon.vertices[j][8] = this.vertices[i + j][8];
                        }
                        this.fpolygon.render();
                    }
                }
                if (!this.stroke) break;
                if (this.shape == 10) {
                    this.draw_lines(this.vertices, this.vertexCount - 1, 1, 1, 0);
                } else {
                    this.draw_lines(this.vertices, this.vertexCount - 1, 1, 1, 3);
                }
                this.draw_lines(this.vertices, this.vertexCount - 2, 2, n2, 0);
                break;
            }
            case 16: {
                int n5;
                if (this.fill || this.textureImage != null) {
                    this.fpolygon.vertexCount = 4;
                    for (n5 = 0; n5 < this.vertexCount - 3; n5 += 4) {
                        for (int i = 0; i < 4; ++i) {
                            int n6 = n5 + i;
                            this.fpolygon.vertices[i][3] = this.vertices[n6][3];
                            this.fpolygon.vertices[i][4] = this.vertices[n6][4];
                            this.fpolygon.vertices[i][5] = this.vertices[n6][5];
                            this.fpolygon.vertices[i][6] = this.vertices[n6][6];
                            this.fpolygon.vertices[i][18] = this.vertices[n6][18];
                            this.fpolygon.vertices[i][19] = this.vertices[n6][19];
                            this.fpolygon.vertices[i][20] = this.vertices[n6][20];
                            if (this.textureImage == null) continue;
                            this.fpolygon.vertices[i][7] = this.vertices[n6][7];
                            this.fpolygon.vertices[i][8] = this.vertices[n6][8];
                        }
                        this.fpolygon.render();
                    }
                }
                if (!this.stroke) break;
                for (n5 = 0; n5 < this.vertexCount - 3; n5 += 4) {
                    this.draw_line(this.vertices[n5 + 0], this.vertices[n5 + 1]);
                    this.draw_line(this.vertices[n5 + 1], this.vertices[n5 + 2]);
                    this.draw_line(this.vertices[n5 + 2], this.vertices[n5 + 3]);
                    this.draw_line(this.vertices[n5 + 3], this.vertices[n5 + 0]);
                }
                break;
            }
            case 17: {
                if (this.fill || this.textureImage != null) {
                    this.fpolygon.vertexCount = 4;
                    for (int i = 0; i < this.vertexCount - 3; i += 2) {
                        for (int j = 0; j < 4; ++j) {
                            int n7 = i + j;
                            if (j == 2) {
                                n7 = i + 3;
                            }
                            if (j == 3) {
                                n7 = i + 2;
                            }
                            this.fpolygon.vertices[j][3] = this.vertices[n7][3];
                            this.fpolygon.vertices[j][4] = this.vertices[n7][4];
                            this.fpolygon.vertices[j][5] = this.vertices[n7][5];
                            this.fpolygon.vertices[j][6] = this.vertices[n7][6];
                            this.fpolygon.vertices[j][18] = this.vertices[n7][18];
                            this.fpolygon.vertices[j][19] = this.vertices[n7][19];
                            this.fpolygon.vertices[j][20] = this.vertices[n7][20];
                            if (this.textureImage == null) continue;
                            this.fpolygon.vertices[j][7] = this.vertices[n7][7];
                            this.fpolygon.vertices[j][8] = this.vertices[n7][8];
                        }
                        this.fpolygon.render();
                    }
                }
                if (!this.stroke) break;
                this.draw_lines(this.vertices, this.vertexCount - 1, 1, 2, 0);
                this.draw_lines(this.vertices, this.vertexCount - 2, 2, 1, 0);
                break;
            }
            case 20: {
                if (this.isConvex()) {
                    if (this.fill || this.textureImage != null) {
                        this.fpolygon.renderPolygon(this.vertices, this.vertexCount);
                    }
                    if (!this.stroke) break;
                    this.draw_lines(this.vertices, this.vertexCount - 1, 1, 1, 0);
                    if (n != 2) break;
                    this.draw_line(this.vertices[this.vertexCount - 1], this.vertices[0]);
                    break;
                }
                if (this.fill || this.textureImage != null) {
                    boolean bl = this.smooth;
                    if (this.stroke) {
                        this.smooth = false;
                    }
                    this.concaveRender();
                    if (this.stroke) {
                        this.smooth = bl;
                    }
                }
                if (!this.stroke) break;
                this.draw_lines(this.vertices, this.vertexCount - 1, 1, 1, 0);
                if (n != 2) break;
                this.draw_line(this.vertices[this.vertexCount - 1], this.vertices[0]);
            }
        }
        this.shape = 0;
    }

    private boolean isConvex() {
        if (this.vertexCount < 3) {
            return true;
        }
        int n = 0;
        for (int i = 0; i < this.vertexCount; ++i) {
            float[] fArray = this.vertices[(i + 1) % this.vertexCount];
            float[] fArray2 = this.vertices[i];
            float[] fArray3 = this.vertices[(i + 2) % this.vertexCount];
            float f = (fArray[18] - fArray2[18]) * (fArray3[19] - fArray[19]) - (fArray[19] - fArray2[19]) * (fArray3[18] - fArray[18]);
            if (f < 0.0f) {
                n |= 1;
            } else if (f > 0.0f) {
                n |= 2;
            }
            if (n != 3) continue;
            return false;
        }
        if (n != 0) {
            return true;
        }
        return true;
    }

    protected void concaveRender() {
        int n;
        if (this.vertexOrder == null || this.vertexOrder.length != this.vertices.length) {
            this.vertexOrder = new int[this.vertices.length];
        }
        if (this.tpolygon == null) {
            this.tpolygon = new PPolygon(this);
        }
        this.tpolygon.reset(3);
        float f = 0.0f;
        int n2 = this.vertexCount - 1;
        int n3 = 0;
        while (n3 < this.vertexCount) {
            f += this.vertices[n3][0] * this.vertices[n2][1] - this.vertices[n2][0] * this.vertices[n3][1];
            n2 = n3++;
        }
        if (f == 0.0f) {
            return;
        }
        float[] fArray = this.vertices[0];
        float[] fArray2 = this.vertices[this.vertexCount - 1];
        if (Math.abs(fArray[0] - fArray2[0]) < 1.0E-4f && Math.abs(fArray[1] - fArray2[1]) < 1.0E-4f && Math.abs(fArray[2] - fArray2[2]) < 1.0E-4f) {
            --this.vertexCount;
        }
        for (n = 0; n < this.vertexCount; ++n) {
            this.vertexOrder[n] = f > 0.0f ? n : this.vertexCount - 1 - n;
        }
        n = this.vertexCount;
        int n4 = 2 * n;
        int n5 = 0;
        int n6 = n - 1;
        while (n > 2) {
            int n7;
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            int n8;
            boolean bl = true;
            if (0 >= n4--) break;
            int n9 = n6;
            if (n <= n9) {
                n9 = 0;
            }
            if (n <= (n6 = n9 + 1)) {
                n6 = 0;
            }
            if (n <= (n8 = n6 + 1)) {
                n8 = 0;
            }
            if ((double)1.0E-4f > ((d6 = (double)(-10.0f * this.vertices[this.vertexOrder[n6]][0])) - (d5 = (double)(-10.0f * this.vertices[this.vertexOrder[n9]][0]))) * ((d4 = (double)(10.0f * this.vertices[this.vertexOrder[n8]][1])) - (d3 = (double)(10.0f * this.vertices[this.vertexOrder[n9]][1]))) - ((d2 = (double)(10.0f * this.vertices[this.vertexOrder[n6]][1])) - d3) * ((d = (double)(-10.0f * this.vertices[this.vertexOrder[n8]][0])) - d5)) continue;
            for (n7 = 0; n7 < n; ++n7) {
                if (n7 == n9 || n7 == n6 || n7 == n8) continue;
                double d7 = -10.0f * this.vertices[this.vertexOrder[n7]][0];
                double d8 = 10.0f * this.vertices[this.vertexOrder[n7]][1];
                double d9 = d - d6;
                double d10 = d4 - d2;
                double d11 = d5 - d;
                double d12 = d3 - d4;
                double d13 = d6 - d5;
                double d14 = d2 - d3;
                double d15 = d7 - d5;
                double d16 = d8 - d3;
                double d17 = d7 - d6;
                double d18 = d8 - d2;
                double d19 = d7 - d;
                double d20 = d8 - d4;
                double d21 = d9 * d18 - d10 * d17;
                double d22 = d13 * d16 - d14 * d15;
                double d23 = d11 * d20 - d12 * d19;
                if (!(d21 >= 0.0) || !(d23 >= 0.0) || !(d22 >= 0.0)) continue;
                bl = false;
            }
            if (!bl) continue;
            this.tpolygon.renderTriangle(this.vertices[this.vertexOrder[n9]], this.vertices[this.vertexOrder[n6]], this.vertices[this.vertexOrder[n8]]);
            ++n5;
            n7 = n6;
            for (int i = n6 + 1; i < n; ++i) {
                this.vertexOrder[n7] = this.vertexOrder[i];
                ++n7;
            }
            n4 = 2 * --n;
        }
    }

    public void point(float f, float f2, float f3) {
        PGraphics2D.showDepthWarningXYZ("point");
    }

    protected void rectImpl(float f, float f2, float f3, float f4) {
        if (this.smooth || this.strokeAlpha || this.ctm.isWarped()) {
            super.rectImpl(f, f2, f3, f4);
        } else {
            int n = (int)(f + this.ctm.m02);
            int n2 = (int)(f2 + this.ctm.m12);
            int n3 = (int)(f3 + this.ctm.m02);
            int n4 = (int)(f4 + this.ctm.m12);
            if (this.fill) {
                this.simple_rect_fill(n, n2, n3, n4);
            }
            if (this.stroke) {
                if (this.strokeWeight == 1.0f) {
                    this.thin_flat_line(n, n2, n3, n2);
                    this.thin_flat_line(n3, n2, n3, n4);
                    this.thin_flat_line(n3, n4, n, n4);
                    this.thin_flat_line(n, n4, n, n2);
                } else {
                    this.thick_flat_line(n, n2, this.strokeR, this.strokeG, this.strokeB, this.strokeA, n3, n2, this.strokeR, this.strokeG, this.strokeB, this.strokeA);
                    this.thick_flat_line(n3, n2, this.strokeR, this.strokeG, this.strokeB, this.strokeA, n3, n4, this.strokeR, this.strokeG, this.strokeB, this.strokeA);
                    this.thick_flat_line(n3, n4, this.strokeR, this.strokeG, this.strokeB, this.strokeA, n, n4, this.strokeR, this.strokeG, this.strokeB, this.strokeA);
                    this.thick_flat_line(n, n4, this.strokeR, this.strokeG, this.strokeB, this.strokeA, n, n2, this.strokeR, this.strokeG, this.strokeB, this.strokeA);
                }
            }
        }
    }

    private void simple_rect_fill(int n, int n2, int n3, int n4) {
        int n5;
        if (n4 < n2) {
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        if (n3 < n) {
            n5 = n;
            n = n3;
            n3 = n5;
        }
        if (n > this.width1 || n3 < 0 || n2 > this.height1 || n4 < 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n3 > this.width) {
            n3 = this.width;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 > this.height) {
            n4 = this.height;
        }
        n5 = n3 - n;
        if (this.fillAlpha) {
            for (int i = n2; i < n4; ++i) {
                int n6 = i * this.width + n;
                for (int j = 0; j < n5; ++j) {
                    this.pixels[n6] = this.blend_fill(this.pixels[n6]);
                    ++n6;
                }
            }
        } else {
            int n7;
            int n8;
            int n9 = n4 - n2;
            int n10 = n8 = n2 * this.width + n;
            for (n7 = 0; n7 < n5; ++n7) {
                this.pixels[n8 + n7] = this.fillColor;
            }
            for (n7 = 0; n7 < n9; ++n7) {
                System.arraycopy(this.pixels, n10, this.pixels, n8, n5);
                n8 += this.width;
            }
        }
    }

    protected void ellipseImpl(float f, float f2, float f3, float f4) {
        if (this.smooth || this.strokeWeight != 1.0f || this.fillAlpha || this.strokeAlpha || this.ctm.isWarped()) {
            int n;
            boolean bl;
            float f5;
            float f6;
            float f7;
            float f8 = f3 / 2.0f;
            float f9 = f4 / 2.0f;
            float f10 = f + f8;
            float f11 = f2 + f9;
            float f12 = this.screenX(f, f2);
            int n2 = (int)((float)Math.PI * 2 * PApplet.dist(f12, f7 = this.screenY(f, f2), f6 = this.screenX(f + f3, f2 + f4), f5 = this.screenY(f + f3, f2 + f4)) / 8.0f);
            if (n2 < 4) {
                return;
            }
            float f13 = 720.0f / (float)n2;
            float f14 = 0.0f;
            if (this.fill) {
                bl = this.stroke;
                this.stroke = false;
                this.beginShape();
                for (n = 0; n < n2; ++n) {
                    this.vertex(f10 + cosLUT[(int)f14] * f8, f11 + sinLUT[(int)f14] * f9);
                    f14 += f13;
                }
                this.endShape(2);
                this.stroke = bl;
            }
            if (this.stroke) {
                bl = this.fill;
                this.fill = false;
                f14 = 0.0f;
                this.beginShape();
                for (n = 0; n < n2; ++n) {
                    this.vertex(f10 + cosLUT[(int)f14] * f8, f11 + sinLUT[(int)f14] * f9);
                    f14 += f13;
                }
                this.endShape(2);
                this.fill = bl;
            }
        } else {
            float f15 = f3 / 2.0f;
            float f16 = f4 / 2.0f;
            int n = (int)(f + f15 + this.ctm.m02);
            int n3 = (int)(f2 + f16 + this.ctm.m12);
            int n4 = (int)f15;
            int n5 = (int)f16;
            if (n4 == n5) {
                if (this.fill) {
                    this.flat_circle_fill(n, n3, n4);
                }
                if (this.stroke) {
                    this.flat_circle_stroke(n, n3, n4);
                }
            } else {
                if (this.fill) {
                    this.flat_ellipse_internal(n, n3, n4, n5, true);
                }
                if (this.stroke) {
                    this.flat_ellipse_internal(n, n3, n4, n5, false);
                }
            }
        }
    }

    private void flat_circle_stroke(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n3;
        int n6 = 1;
        int n7 = 2 * n3 - 1;
        int n8 = 0;
        while (n4 < n5) {
            this.thin_point(n + n4, n2 + n5, this.strokeColor);
            this.thin_point(n + n5, n2 - n4, this.strokeColor);
            this.thin_point(n - n4, n2 - n5, this.strokeColor);
            this.thin_point(n - n5, n2 + n4, this.strokeColor);
            ++n4;
            if (n7 < 2 * (n8 += (n6 += 2))) {
                --n5;
                n8 -= n7;
                n7 -= 2;
            }
            if (n4 > n5) break;
            this.thin_point(n + n5, n2 + n4, this.strokeColor);
            this.thin_point(n + n4, n2 - n5, this.strokeColor);
            this.thin_point(n - n5, n2 - n4, this.strokeColor);
            this.thin_point(n - n4, n2 + n5, this.strokeColor);
        }
    }

    private void flat_circle_fill(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n3;
        int n6 = 1;
        int n7 = 2 * n3 - 1;
        int n8 = 0;
        while (n4 < n5) {
            int n9;
            for (n9 = n; n9 < n + n4; ++n9) {
                this.thin_point(n9, n2 + n5, this.fillColor);
            }
            for (n9 = n; n9 < n + n5; ++n9) {
                this.thin_point(n9, n2 - n4, this.fillColor);
            }
            for (n9 = n - n4; n9 < n; ++n9) {
                this.thin_point(n9, n2 - n5, this.fillColor);
            }
            for (n9 = n - n5; n9 < n; ++n9) {
                this.thin_point(n9, n2 + n4, this.fillColor);
            }
            ++n4;
            if (n7 < 2 * (n8 += (n6 += 2))) {
                --n5;
                n8 -= n7;
                n7 -= 2;
            }
            if (n4 > n5) break;
            for (n9 = n; n9 < n + n5; ++n9) {
                this.thin_point(n9, n2 + n4, this.fillColor);
            }
            for (n9 = n; n9 < n + n4; ++n9) {
                this.thin_point(n9, n2 - n5, this.fillColor);
            }
            for (n9 = n - n5; n9 < n; ++n9) {
                this.thin_point(n9, n2 - n4, this.fillColor);
            }
            for (n9 = n - n4; n9 < n; ++n9) {
                this.thin_point(n9, n2 + n5, this.fillColor);
            }
        }
    }

    private final void flat_ellipse_symmetry(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            for (int i = n - n3 + 1; i < n + n3; ++i) {
                this.thin_point(i, n2 - n4, this.fillColor);
                this.thin_point(i, n2 + n4, this.fillColor);
            }
        } else {
            this.thin_point(n - n3, n2 + n4, this.strokeColor);
            this.thin_point(n + n3, n2 + n4, this.strokeColor);
            this.thin_point(n - n3, n2 - n4, this.strokeColor);
            this.thin_point(n + n3, n2 - n4, this.strokeColor);
        }
    }

    private void flat_ellipse_internal(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3 * n3;
        int n6 = n4 * n4;
        int n7 = 0;
        int n8 = n4;
        int n9 = n5 * (1 - 2 * n4) + 2 * n6;
        int n10 = n6 - 2 * n5 * (2 * n4 - 1);
        this.flat_ellipse_symmetry(n, n2, n7, n8, bl);
        do {
            if (n9 < 0) {
                n9 += 2 * n6 * (2 * n7 + 3);
                n10 += 4 * n6 * (n7 + 1);
                ++n7;
            } else if (n10 < 0) {
                n9 += 2 * n6 * (2 * n7 + 3) - 4 * n5 * (n8 - 1);
                n10 += 4 * n6 * (n7 + 1) - 2 * n5 * (2 * n8 - 3);
                ++n7;
                --n8;
            } else {
                n9 -= 4 * n5 * (n8 - 1);
                n10 -= 2 * n5 * (2 * n8 - 3);
                --n8;
            }
            this.flat_ellipse_symmetry(n, n2, n7, n8, bl);
        } while (n8 > 0);
    }

    protected void arcImpl(float f, float f2, float f3, float f4, float f5, float f6) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl;
        float f7 = f3 / 2.0f;
        float f8 = f4 / 2.0f;
        float f9 = f + f7;
        float f10 = f2 + f8;
        if (this.fill) {
            bl = this.stroke;
            this.stroke = false;
            n4 = (int)(-0.5f + f5 / ((float)Math.PI * 2) * 720.0f);
            n3 = (int)(0.5f + f6 / ((float)Math.PI * 2) * 720.0f);
            this.beginShape();
            this.vertex(f9, f10);
            for (n2 = n4; n2 < n3; ++n2) {
                n = n2 % 720;
                if (n < 0) {
                    n += 720;
                }
                this.vertex(f9 + cosLUT[n] * f7, f10 + sinLUT[n] * f8);
            }
            this.endShape(2);
            this.stroke = bl;
        }
        if (this.stroke) {
            bl = this.fill;
            this.fill = false;
            n4 = (int)(0.5f + f5 / ((float)Math.PI * 2) * 720.0f);
            n3 = (int)(0.5f + f6 / ((float)Math.PI * 2) * 720.0f);
            this.beginShape();
            n2 = 1;
            for (n = n4; n < n3; n += n2) {
                int n5 = n % 720;
                if (n5 < 0) {
                    n5 += 720;
                }
                this.vertex(f9 + cosLUT[n5] * f7, f10 + sinLUT[n5] * f8);
            }
            this.vertex(f9 + cosLUT[n3 % 720] * f7, f10 + sinLUT[n3 % 720] * f8);
            this.endShape();
            this.fill = bl;
        }
    }

    public void box(float f) {
        PGraphics2D.showDepthWarning("box");
    }

    public void box(float f, float f2, float f3) {
        PGraphics2D.showDepthWarning("box");
    }

    public void sphereDetail(int n) {
        PGraphics2D.showDepthWarning("sphereDetail");
    }

    public void sphereDetail(int n, int n2) {
        PGraphics2D.showDepthWarning("sphereDetail");
    }

    public void sphere(float f) {
        PGraphics2D.showDepthWarning("sphere");
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        PGraphics2D.showDepthWarningXYZ("bezier");
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        PGraphics2D.showDepthWarningXYZ("curve");
    }

    protected void imageImpl(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        if (f3 - f == (float)pImage.width && f4 - f2 == (float)pImage.height && !this.tint && !this.ctm.isWarped()) {
            this.simple_image(pImage, (int)(f + this.ctm.m02), (int)(f2 + this.ctm.m12), n, n2, n3, n4);
        } else {
            super.imageImpl(pImage, f, f2, f3, f4, n, n2, n3, n4);
        }
    }

    private void simple_image(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6) {
        block11: {
            int n7;
            int n8;
            int n9;
            int n10;
            block12: {
                block10: {
                    n10 = n + pImage.width;
                    n9 = n2 + pImage.height;
                    if (n > this.width1 || n10 < 0 || n2 > this.height1 || n9 < 0) {
                        return;
                    }
                    if (n < 0) {
                        n3 -= n;
                        n = 0;
                    }
                    if (n2 < 0) {
                        n4 -= n2;
                        n2 = 0;
                    }
                    if (n10 > this.width) {
                        n5 -= n10 - this.width;
                        n10 = this.width;
                    }
                    if (n9 > this.height) {
                        n6 -= n9 - this.height;
                        n9 = this.height;
                    }
                    n8 = n4 * pImage.width + n3;
                    n7 = n2 * this.width;
                    if (pImage.format != 2) break block10;
                    for (int i = n2; i < n9; ++i) {
                        int n11 = 0;
                        for (int j = n; j < n10; ++j) {
                            this.pixels[n7 + j] = this.blend_color(this.pixels[n7 + j], pImage.pixels[n8 + n11++]);
                        }
                        n8 += pImage.width;
                        n7 += this.width;
                    }
                    break block11;
                }
                if (pImage.format != 4) break block12;
                for (int i = n2; i < n9; ++i) {
                    int n12 = 0;
                    for (int j = n; j < n10; ++j) {
                        this.pixels[n7 + j] = this.blend_color_alpha(this.pixels[n7 + j], this.fillColor, pImage.pixels[n8 + n12++]);
                    }
                    n8 += pImage.width;
                    n7 += this.width;
                }
                break block11;
            }
            if (pImage.format != 1) break block11;
            n7 += n;
            int n13 = n10 - n;
            for (int i = n2; i < n9; ++i) {
                System.arraycopy(pImage.pixels, n8, this.pixels, n7, n13);
                n8 += pImage.width;
                n7 += this.width;
            }
        }
    }

    private void thin_point_at(int n, int n2, float f, int n3) {
        int n4 = n2 * this.width + n;
        this.pixels[n4] = n3;
    }

    private void thin_point_at_index(int n, float f, int n2) {
        this.pixels[n] = n2;
    }

    private void thick_point(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.spolygon.reset(4);
        this.spolygon.interpARGB = false;
        float f8 = this.strokeWeight / 2.0f;
        float[] fArray = this.spolygon.vertices[0];
        fArray[18] = f - f8;
        fArray[19] = f2 - f8;
        fArray[20] = f3;
        fArray[3] = f4;
        fArray[4] = f5;
        fArray[5] = f6;
        fArray[6] = f7;
        fArray = this.spolygon.vertices[1];
        fArray[18] = f + f8;
        fArray[19] = f2 - f8;
        fArray[20] = f3;
        fArray = this.spolygon.vertices[2];
        fArray[18] = f + f8;
        fArray[19] = f2 + f8;
        fArray[20] = f3;
        fArray = this.spolygon.vertices[3];
        fArray[18] = f - f8;
        fArray[19] = f2 + f8;
        fArray[20] = f3;
        this.spolygon.render();
    }

    private void thin_flat_line(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = this.thin_flat_line_clip_code(n, n2);
        if ((n11 & (n10 = this.thin_flat_line_clip_code(n3, n4))) != 0) {
            return;
        }
        int n12 = n11 | n10;
        if (n12 != 0) {
            float f = 0.0f;
            float f2 = 1.0f;
            float f3 = 0.0f;
            for (n9 = 0; n9 < 4; ++n9) {
                if ((n12 >> n9) % 2 != 1) continue;
                f3 = this.thin_flat_line_slope(n, n2, n3, n4, n9 + 1);
                if ((n11 >> n9) % 2 == 1) {
                    f = Math.max(f3, f);
                    continue;
                }
                f2 = Math.min(f3, f2);
            }
            if (f > f2) {
                return;
            }
            n8 = (int)((float)n + f * (float)(n3 - n));
            n7 = (int)((float)n2 + f * (float)(n4 - n2));
            n6 = (int)((float)n + f2 * (float)(n3 - n));
            n5 = (int)((float)n2 + f2 * (float)(n4 - n2));
        } else {
            n8 = n;
            n6 = n3;
            n7 = n2;
            n5 = n4;
        }
        n12 = 0;
        int n13 = n5 - n7;
        int n14 = n6 - n8;
        if (Math.abs(n13) > Math.abs(n14)) {
            int n15 = n13;
            n13 = n14;
            n14 = n15;
            n12 = 1;
        }
        int n16 = n14 == 0 ? 0 : (n13 << 16) / n14;
        if (n8 == n6) {
            if (n7 > n5) {
                n9 = n7;
                n7 = n5;
                n5 = n9;
            }
            n9 = n7 * this.width + n8;
            for (int i = n7; i <= n5; ++i) {
                this.thin_point_at_index(n9, 0.0f, this.strokeColor);
                n9 += this.width;
            }
            return;
        }
        if (n7 == n5) {
            if (n8 > n6) {
                n9 = n8;
                n8 = n6;
                n6 = n9;
            }
            n9 = n7 * this.width + n8;
            for (int i = n8; i <= n6; ++i) {
                this.thin_point_at_index(n9++, 0.0f, this.strokeColor);
            }
            return;
        }
        if (n12 != 0) {
            if (n14 > 0) {
                n14 += n7;
                n9 = 32768 + (n8 << 16);
                while (n7 <= n14) {
                    this.thin_point_at(n9 >> 16, n7, 0.0f, this.strokeColor);
                    n9 += n16;
                    ++n7;
                }
                return;
            }
            n14 += n7;
            n9 = 32768 + (n8 << 16);
            while (n7 >= n14) {
                this.thin_point_at(n9 >> 16, n7, 0.0f, this.strokeColor);
                n9 -= n16;
                --n7;
            }
            return;
        }
        if (n14 > 0) {
            n14 += n8;
            n9 = 32768 + (n7 << 16);
            while (n8 <= n14) {
                this.thin_point_at(n8, n9 >> 16, 0.0f, this.strokeColor);
                n9 += n16;
                ++n8;
            }
            return;
        }
        n14 += n8;
        n9 = 32768 + (n7 << 16);
        while (n8 >= n14) {
            this.thin_point_at(n8, n9 >> 16, 0.0f, this.strokeColor);
            n9 -= n16;
            --n8;
        }
    }

    private int thin_flat_line_clip_code(float f, float f2) {
        return (f2 < 0.0f ? 8 : 0) | (f2 > (float)this.height1 ? 4 : 0) | (f < 0.0f ? 2 : 0) | (f > (float)this.width1 ? 1 : 0);
    }

    private float thin_flat_line_slope(float f, float f2, float f3, float f4, int n) {
        switch (n) {
            case 4: {
                return -f2 / (f4 - f2);
            }
            case 3: {
                return ((float)this.height1 - f2) / (f4 - f2);
            }
            case 2: {
                return -f / (f3 - f);
            }
            case 1: {
                return ((float)this.width1 - f) / (f3 - f);
            }
        }
        return -1.0f;
    }

    private void thick_flat_line(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.spolygon.interpARGB = f3 != f9 || f4 != f10 || f5 != f11 || f6 != f12;
        float f13 = f7 - f + 1.0E-4f;
        float f14 = f8 - f2 + 1.0E-4f;
        float f15 = (float)Math.sqrt(f13 * f13 + f14 * f14);
        float f16 = this.strokeWeight / f15 / 2.0f;
        float f17 = f16 * f14;
        float f18 = f16 * f13;
        float f19 = f16 * f14;
        float f20 = f16 * f13;
        this.spolygon.reset(4);
        float[] fArray = this.spolygon.vertices[0];
        fArray[18] = f + f17;
        fArray[19] = f2 - f18;
        fArray[3] = f3;
        fArray[4] = f4;
        fArray[5] = f5;
        fArray[6] = f6;
        fArray = this.spolygon.vertices[1];
        fArray[18] = f - f17;
        fArray[19] = f2 + f18;
        fArray[3] = f3;
        fArray[4] = f4;
        fArray[5] = f5;
        fArray[6] = f6;
        fArray = this.spolygon.vertices[2];
        fArray[18] = f7 - f19;
        fArray[19] = f8 + f20;
        fArray[3] = f9;
        fArray[4] = f10;
        fArray[5] = f11;
        fArray[6] = f12;
        fArray = this.spolygon.vertices[3];
        fArray[18] = f7 + f19;
        fArray[19] = f8 - f20;
        fArray[3] = f9;
        fArray[4] = f10;
        fArray[5] = f11;
        fArray[6] = f12;
        this.spolygon.render();
    }

    private void draw_line(float[] fArray, float[] fArray2) {
        if (this.strokeWeight == 1.0f) {
            if (this.line == null) {
                this.line = new PLine(this);
            }
            this.line.reset();
            this.line.setIntensities(fArray[13], fArray[14], fArray[15], fArray[16], fArray2[13], fArray2[14], fArray2[15], fArray2[16]);
            this.line.setVertices(fArray[18], fArray[19], fArray[20], fArray2[18], fArray2[19], fArray2[20]);
            this.line.draw();
        } else {
            this.thick_flat_line(fArray[18], fArray[19], fArray[13], fArray[14], fArray[15], fArray[16], fArray2[18], fArray2[19], fArray2[13], fArray2[14], fArray2[15], fArray2[16]);
        }
    }

    private void draw_lines(float[][] fArray, int n, int n2, int n3, int n4) {
        if (this.strokeWeight == 1.0f) {
            for (int i = 0; i < n; i += n3) {
                if (n4 != 0 && (i + n2) % n4 == 0) continue;
                float[] fArray2 = fArray[i];
                float[] fArray3 = fArray[i + n2];
                if (this.line == null) {
                    this.line = new PLine(this);
                }
                this.line.reset();
                this.line.setIntensities(fArray2[13], fArray2[14], fArray2[15], fArray2[16], fArray3[13], fArray3[14], fArray3[15], fArray3[16]);
                this.line.setVertices(fArray2[18], fArray2[19], fArray2[20], fArray3[18], fArray3[19], fArray3[20]);
                this.line.draw();
            }
        } else {
            for (int i = 0; i < n; i += n3) {
                if (n4 != 0 && (i + n2) % n4 == 0) continue;
                float[] fArray4 = fArray[i];
                float[] fArray5 = fArray[i + n2];
                this.thick_flat_line(fArray4[18], fArray4[19], fArray4[13], fArray4[14], fArray4[15], fArray4[16], fArray5[18], fArray5[19], fArray5[13], fArray5[14], fArray5[15], fArray5[16]);
            }
        }
    }

    private void thin_point(float f, float f2, int n) {
        int n2 = (int)(f + 0.4999f);
        int n3 = (int)(f2 + 0.4999f);
        if (n2 < 0 || n2 > this.width1 || n3 < 0 || n3 > this.height1) {
            return;
        }
        int n4 = n3 * this.width + n2;
        if ((n & 0xFF000000) == -16777216) {
            this.pixels[n4] = n;
        } else {
            int n5 = n >> 24 & 0xFF;
            int n6 = n5 ^ 0xFF;
            int n7 = this.strokeColor;
            int n8 = this.pixels[n4];
            int n9 = n6 * (n8 >> 16 & 0xFF) + n5 * (n7 >> 16 & 0xFF) & 0xFF00;
            int n10 = n6 * (n8 >> 8 & 0xFF) + n5 * (n7 >> 8 & 0xFF) & 0xFF00;
            int n11 = n6 * (n8 & 0xFF) + n5 * (n7 & 0xFF) >> 8;
            this.pixels[n4] = 0xFF000000 | n9 << 8 | n10 | n11;
        }
    }

    public void translate(float f, float f2) {
        this.ctm.translate(f, f2);
    }

    public void translate(float f, float f2, float f3) {
        PGraphics2D.showDepthWarningXYZ("translate");
    }

    public void rotate(float f) {
        this.ctm.rotate(f);
    }

    public void rotateX(float f) {
        PGraphics2D.showDepthWarning("rotateX");
    }

    public void rotateY(float f) {
        PGraphics2D.showDepthWarning("rotateY");
    }

    public void rotateZ(float f) {
        PGraphics2D.showDepthWarning("rotateZ");
    }

    public void rotate(float f, float f2, float f3, float f4) {
        PGraphics2D.showVariationWarning("rotate(angle, x, y, z)");
    }

    public void scale(float f) {
        this.ctm.scale(f);
    }

    public void scale(float f, float f2) {
        this.ctm.scale(f, f2);
    }

    public void scale(float f, float f2, float f3) {
        PGraphics2D.showDepthWarningXYZ("scale");
    }

    public void pushMatrix() {
        if (this.matrixStackDepth == 32) {
            throw new RuntimeException("Too many calls to pushMatrix().");
        }
        this.ctm.get(this.matrixStack[this.matrixStackDepth]);
        ++this.matrixStackDepth;
    }

    public void popMatrix() {
        if (this.matrixStackDepth == 0) {
            throw new RuntimeException("Too many calls to popMatrix(), and not enough to pushMatrix().");
        }
        --this.matrixStackDepth;
        this.ctm.set(this.matrixStack[this.matrixStackDepth]);
    }

    public void resetMatrix() {
        this.ctm.reset();
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.ctm.apply(f, f2, f3, f4, f5, f6);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        PGraphics2D.showDepthWarningXYZ("applyMatrix");
    }

    public void printMatrix() {
        this.ctm.print();
    }

    public float screenX(float f, float f2) {
        return this.ctm.m00 * f + this.ctm.m01 * f2 + this.ctm.m02;
    }

    public float screenY(float f, float f2) {
        return this.ctm.m10 * f + this.ctm.m11 * f2 + this.ctm.m12;
    }

    protected void backgroundImpl() {
        Arrays.fill(this.pixels, this.backgroundColor);
    }

    private final int blend_fill(int n) {
        int n2 = this.fillAi;
        int n3 = n2 ^ 0xFF;
        int n4 = n3 * (n >> 16 & 0xFF) + n2 * this.fillRi & 0xFF00;
        int n5 = n3 * (n >> 8 & 0xFF) + n2 * this.fillGi & 0xFF00;
        int n6 = n3 * (n & 0xFF) + n2 * this.fillBi & 0xFF00;
        return 0xFF000000 | n4 << 8 | n5 | n6 >> 8;
    }

    private final int blend_color(int n, int n2) {
        int n3 = n2 >>> 24;
        if (n3 == 255) {
            return n2;
        }
        int n4 = n3 ^ 0xFF;
        int n5 = n4 * (n >> 16 & 0xFF) + n3 * (n2 >> 16 & 0xFF) & 0xFF00;
        int n6 = n4 * (n >> 8 & 0xFF) + n3 * (n2 >> 8 & 0xFF) & 0xFF00;
        int n7 = n4 * (n & 0xFF) + n3 * (n2 & 0xFF) >> 8;
        return 0xFF000000 | n5 << 8 | n6 | n7;
    }

    private final int blend_color_alpha(int n, int n2, int n3) {
        n3 = n3 * (n2 >>> 24) >> 8;
        int n4 = n3 ^ 0xFF;
        int n5 = n4 * (n >> 16 & 0xFF) + n3 * (n2 >> 16 & 0xFF) & 0xFF00;
        int n6 = n4 * (n >> 8 & 0xFF) + n3 * (n2 >> 8 & 0xFF) & 0xFF00;
        int n7 = n4 * (n & 0xFF) + n3 * (n2 & 0xFF) >> 8;
        return 0xFF000000 | n5 << 8 | n6 | n7;
    }
}

