//[VERT]
attribute vec3 position;
attribute vec3 normal;
attribute vec3 normal2;
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
varying vec3 vNormal;
varying vec3 vNormal2;
varying vec3 wPos;
varying vec3 wL;
varying float depth;

void main()
{
	vec3 lightPos = vec3(0.0, 10.0, 10.0);
	wL = (modelViewMatrix * vec4(lightPos, 1.0)).xyz;
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	wPos = position;
	vNormal = normal;
	vNormal2 = normal2;
	depth = (6.0-length(vec3(position.x, 0, position.z))) / 6.0;
}

//[FRAG]

varying vec3 vNormal;
varying vec3 vNormal2;
varying vec3 wPos;
uniform vec4 color;
uniform float time;
varying vec3 wL;
varying float depth;

void main()
{
	vec4 ambientColor = vec4(0.5);
	vec4 specularColor = vec4(0.9, 0.9, 0.9, 1.0);
	//vec4 skyColor = vec4(169.0/255.0, 231.0/255.0, 255.0/255.0, 1.0);
	vec4 skyColor = vec4(1, 1, 1, 1.0);
	vec4 landColor = vec4(82.0/255.0, 11.0/255.0, 49.0/255.0, 1.0);	
	
	vec3 camPos = vec3(0.0, 8.0, 3.0);
	
	vec3 N = normalize(vNormal);	
	vec3 L = normalize(wL - wPos);
	float NdotL = max(0.0, dot(N, L));
	
	
		//float dist = length(wL) + 0.00001;
//	float quadraticAttenuation = 0.5;
//	float attenuation = 1.0 / (quadraticAttenuation * dist);
//	vec3 N = normalize(wN);
//	vec3 L = normalize(wL);
//	float specular = 0.0;
//	
//	float NdotL = max(0.0, dot(N, L));
//	if (NdotL != 0.0) {
	vec3 halfVector = normalize(normalize(camPos) + L);
	float NdotHV = max(0.0, dot(N, halfVector));
	float shininess = 64.0;
	float specular = pow(NdotHV, shininess); 
	
	gl_FragColor = mix(ambientColor, skyColor, 0.0 + 0.99*NdotL);
	gl_FragColor += specularColor * specular;
	//gl_FragColor.rgb *= min(1.0, (80.0 + wPos.z)/30.0);
	
	gl_FragColor.rgb *= vNormal2 * (0.5 + 0.5*sin(vNormal2.x + time * 10.0));
	gl_FragColor.rgb += vec3(0.4);
	gl_FragColor.a = color.a;
	
}
