//[VERT]
attribute vec3 position;
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelWorldMatrix;
varying vec3 vPos;

void main()
{
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	vPos = (modelWorldMatrix * vec4(position, 1.0)).xyz;
	vPos.x += 2.5;
	vPos.z += 2.5;		
	vPos /= 20.0;
	vPos += vec3(0.5);	
}

//[FRAG]

uniform vec4 color;
varying vec3 vPos;

void main()
{
	gl_FragColor.rgb = vPos;	
	gl_FragColor.a = color.a;
}
