//[VERT]
attribute vec3 position;
attribute vec3 position2;
attribute vec3 velocity;
attribute vec2 texCoord0;
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform float time;

varying vec2 vTexCoord0;

void main()
{
	float t = 0.5+0.5*sin(time/2.0);
	
	vec3 pos = mix(position, position2, t);
	float d = (1.0-abs(mix(-1.0, 1.0, t)));	
	vec2 center = vec2(0.5, 0.5);	
	float l = sqrt((texCoord0.s-center.x)*(texCoord0.s-center.x) + (texCoord0.t-center.y)*(texCoord0.t-center.y));
	pos.z += sin(l * 3.14 * 5.0 + time*2.0) * d;
	pos += normalize(velocity) * d / 2.0;	
	gl_Position = projectionMatrix * modelViewMatrix * vec4(pos, 1.0);
	vTexCoord0 = texCoord0;	
	gl_PointSize = 1.0;
}

//[FRAG]

//#version 120

uniform sampler2D tex0;
uniform sampler2D tex1;
uniform sampler2D tex2;
uniform float time;
varying vec2 vTexCoord0;

void main()
{
	float t = 0.5+0.5*sin(time/2.0);
	float d = (abs(mix(-1.0, 1.0, t)));	
	//vec4 alphaMask = texture2D(tex0, gl_PointCoord);
	vec4 color = texture2D(tex1, vTexCoord0);
	vec4 color2 = texture2D(tex2, vTexCoord0);
	//gl_FragColor = alphaMask*mix(color, color2, t);
	gl_FragColor = mix(color, color2, t);
}

