//[VERT]
attribute vec3 position;
attribute vec2 texCoord0;
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
varying vec2 vTexCoord0;
varying float vDepth;

void main()
{
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	vDepth = 1.0-gl_Position.z/6.0;
	vTexCoord0 = texCoord0;
}

//[FRAG]
uniform sampler2D tex0;
varying vec2 vTexCoord0;
varying float vDepth;

void main()
{
	gl_FragColor = texture2D(tex0, vTexCoord0);
	gl_FragColor.a = vDepth;
	//gl_FragColor = vec4(1.0, 0.0, 0.0, 0.0);
}
