//[VERT]
attribute vec3 position;
attribute vec3 normal;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

varying vec3 wN; //normal in world space
varying vec3 wL; //vector from position to light in world space

void main()
{
	vec3 lightPos = vec3(-30, 30,30);
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	vec3 wPos = vec3(modelViewMatrix * vec4(position, 1.0));
	wN = normal;
	wL = lightPos - wPos;
}

//[FRAG]
varying vec3 wN; //normal in eye space
varying vec3 wL; //vector from position to light in eye space

void main()
{
	vec3 color = vec3(0.4, 0.4, 0.4);
	vec3 N = normalize(wN);
	vec3 L = normalize(wL);
	float NdotL = abs(dot(N, L));
	if (NdotL < 0.0) {
		NdotL = 0.0;
	}
	gl_FragColor.rgb = color * vec3(0.3 + 0.7*NdotL);
	//gl_FragColor.rgb = vec3(0.5 + L.y*0.5);//color * vec3(0.3 + 0.7*NdotL);
	//gl_FragColor.rgb = vec3(0.5 + N.y*0.5);//color * vec3(0.3 + 0.7*NdotL);
}
