//[VERT]
attribute vec3 position;
attribute vec3 normal;

uniform mat4 projectionMatrix;
uniform mat4 modelWorldMatrix;
uniform mat3 normalMatrix;
uniform mat4 modelViewMatrix;

varying vec3 vTexCoord0;
varying vec3 vN;
varying vec3 vL;
varying float vDepth;

void main()
{
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);			
	vTexCoord0 = (modelWorldMatrix * vec4(position, 1.0)).xyz;
	vN = (modelWorldMatrix * vec4(normal, 0.0)).xyz;
	//vN = (modelWorldMatrix * vec4(normal, 0.0)).xyz;
	vL = vec3(10, 10, 10);
	
	float minDepth = 5.0;
	float maxDepth = 10.0;
	//vDepth = 1.0-(gl_Position.z - minDepth)/(maxDepth-minDepth);
	vDepth = (length(vTexCoord0) - 0.0)/5.0;
}

//[FRAG]
uniform samplerCube envMap;
varying vec3 vTexCoord0;
varying vec3 vN;
varying vec3 vL;
varying float vDepth;

void main()
{
	float NdotL = max(0.0, dot(normalize(vN), normalize(vL)));
	vec3 ambient = vec3(0.3);
	vec3 diffuse = vec3(0.5);
	gl_FragColor.rgb = ambient + 0.8*mix(diffuse,textureCube(envMap, vN).rgb, 0.9) * (0.4 + 0.6*NdotL);
	gl_FragColor = vec4(vDepth);
	//gl_FragColor.rgb = vec3(0.5) + vec3(0.5*normalize(vN).y);
	//gl_FragColor.rgb = vec3(NdotL);
}
