//[VERT]
attribute vec2 position;
attribute vec2 texCoord0;
varying vec2 vTexCoord0;

void main()
{
	gl_Position = vec4(position.x, position.y, 0.0, 1.0);
	vTexCoord0 = texCoord0;
}

//[FRAG]

//#version 120

uniform sampler2D tex0;
uniform sampler2D blurredTex1;
uniform sampler2D depthTex2;
uniform float focalDistance;
uniform float focalRange;
varying vec2 vTexCoord0;
	
void main()
{
	vec4 depth = texture2D(depthTex2, vTexCoord0);
	vec4 color = texture2D(tex0, vTexCoord0);
	vec4 blur = texture2D(blurredTex1, vTexCoord0);
	
	float d = max(0.0, depth.r - 0.5) * 2.0;
	gl_FragColor = mix(color, blur, d);	
}