//[VERT]
attribute vec3 position;
attribute vec3 normal;
uniform mat4 projectionMatrix;
uniform mat4 modelWorldMatrix;
uniform mat4 modelViewMatrix;
varying vec3 vNormal;

void main()
{
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	vNormal = normal;
}

//[FRAG]

varying vec3 vNormal;

void main()
{
	vec4 skyColor = vec4(169.0/255.0, 231.0/255.0, 255.0/255.0, 1.0);
	vec4 landColor = vec4(82.0/255.0, 11.0/255.0, 49.0/255.0, 1.0);	
	vec3 camPos = vec3(0.0, 10.0, 0.0);
	
	vec3 N = normalize(vNormal);	
	vec3 L = vec3(0.0, 1.0, 0.0);
	float NdotL = dot(N, L);
	gl_FragColor = mix(landColor, skyColor, 0.5 + 0.5*NdotL);
}
