//[VERT]
attribute vec3 position;
attribute vec3 normal;
attribute vec3 normal2;
uniform mat4 projectionMatrix;
uniform mat4 modelWorldMatrix;
uniform mat4 modelViewMatrix;
varying vec3 vNormal;
varying vec3 vNormal2;
varying vec3 wPos;
varying vec2 vScreenPos;

void main()
{
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	vScreenPos = gl_Position.xy;
	wPos = (modelWorldMatrix * vec4(position, 1.0)).xyz;
	vNormal = normal;
	vNormal2 = normal2;
}

//[FRAG]

varying vec3 vNormal;
varying vec3 vNormal2;
varying vec3 wPos;
varying vec2 vScreenPos;
uniform float maskSign;

void main()
{
	if (vScreenPos.y*maskSign > 0.0) {
		discard;
	}
	
	vec4 ambientColor = vec4(0.2);
	vec4 skyColor = vec4(169.0/255.0, 231.0/255.0, 255.0/255.0, 1.0);
	vec4 landColor = vec4(82.0/255.0, 11.0/255.0, 49.0/255.0, 1.0);	
	vec3 camPos = vec3(0.0, 10.0, 0.0);
	
	vec3 N = normalize(vNormal);	
	vec3 N2 = normalize(vNormal2);
	vec3 L = normalize(camPos - wPos);
	float NdotL = dot(N, L);
	float N2dotL = dot(N2, L);
	//gl_FragColor = mix(ambientColor, skyColor, max(0.0, NdotL));
	gl_FragColor = mix(landColor, skyColor, 0.5 + 0.5*N2dotL) * (0.75 + max(0.0, NdotL)*0.25);
	//gl_FragColor = vec4(0.5) + vec4(0.5*N, 1.0);
}
