//[VERT]
attribute vec3 position;
attribute vec3 normal;
attribute vec2 texCoord0;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelWorldMatrix;
uniform vec3 camPos;
uniform vec3 lightPos;
uniform vec4 ambientColor;
uniform vec4 diffuseColor;
uniform vec4 specularColor;

varying vec3 reflectDir;
varying vec3 reflectDir2;
varying vec2 texCoord0Var;
varying vec4 color;

void main()
{
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);	
	vec3 worldPos = vec3(modelWorldMatrix * vec4(position, 1.0));
	vec3 N = normalize(vec3(modelWorldMatrix * vec4(normal, 1.0)));
	vec3 E = normalize(camPos - worldPos);
	vec3 L = normalize(lightPos - worldPos);
	reflectDir = reflect(-E, N);
	reflectDir2 = -reflect(-E, N);					

	texCoord0Var = texCoord0;
	
	float NdotL = max(0.0, dot(N, L));	
	vec3 R = reflect(-L, N);
	float RdotE = max(0.0, dot(R, E));
	float spec = pow(RdotE, 64.0);
	
	color = ambientColor + diffuseColor*NdotL + specularColor*spec;
	
}

//[FRAG]
uniform samplerCube tex0;
uniform samplerCube tex1;
varying highp vec3 reflectDir;
varying highp vec3 reflectDir2;
varying highp vec2 texCoord0Var;
varying vec4 color;

void main()
{
	//gl_FragColor = color * textureCube(tex0, reflectDir);
	float f = 0.5;
	gl_FragColor = color * 0.25*(textureCube(tex0, reflectDir) + textureCube(tex1, reflectDir2 + vec3(-0.5, 0.2, 0.0))  + textureCube(tex1, reflectDir2 + vec3(0.1, 0.5, 0.4))  + textureCube(tex1, reflectDir2 + vec3(-0.1, 0.5, -0.4)) + textureCube(tex1, reflectDir2 + vec3(0.45, -0.25, -0.4)));
}
