//[VERT]
attribute vec3 position;
attribute vec3 normal;
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

varying vec3 vNormal;
uniform float depthShift;

void main()
{
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	gl_Position.z += depthShift;
	vNormal = normal;
}

//[FRAG]

uniform vec3 color;
varying vec3 vNormal;

void main()
{
	gl_FragColor.rgb = color * (vec3(0.3)+vec3(0.5)+0.5*vec3((vNormal.r + vNormal.g + vNormal.b)/3.0));
}
