//[VERT]
attribute vec3 position;
attribute vec4 color;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

varying vec4 vColor;

void main()
{
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	gl_PointSize = 20.0 + 100.0 * color.a;	
	vColor = color;
}

//[FRAG]
uniform sampler2D tex0;

varying vec4 vColor;

void main()
{
	vec4 mask = texture2D(tex0, gl_PointCoord);	
	gl_FragColor = vec4(vColor.rgb, vColor.a * mask.r);
}
