//[VERT]
attribute vec3 position;
attribute vec3 normal;
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
varying vec3 vNormal;

void main()
{
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	vNormal = normal;
}

//[FRAG]

varying vec3 vNormal;

void main()
{
	vec3 N = normalize(vNormal);
	gl_FragColor.rgb = vec3(0.5) + 0.5*N;
}
