import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class XformChooser 
extends ParameterGroup 
implements Xform, ActionListener, ParameterListener {
	private static final String NONE_STR = "None";

	ParameterListener listener;

	JPanel gui_panel;
	JComboBox combo_box;
	JPanel card_panel;
	CardLayout card_layout;
	XformSkeleton[] xforms;
	XformSkeleton xf;
	boolean ignore_change;

	public XformChooser(ParameterListener listener) {
		super("XFORM_CHOOSER-?", "Xform ?", null);
		this.listener = listener;

		xforms = new XformSkeleton[] {
			new XformAffine(this),
			new XformAffine3D(this),
			new XformPoly(this),
			new XformPoly3D(this),
			new XformZPoly(this),
			new XformQuaternion(this),
			new XformHelix(this),
			new XformRipple(this)
		};

		super.addParameter(new ObjectParameter("XFORM_TYPE", NONE_STR));
//		super.addParameter(new ObjectParameter("XFORM_PARAMS", "null"));
		super.addParameterListener(this);
	}

	public JPanel getGUI() {
		if(gui_panel != null) return gui_panel;

		gui_panel = new JPanel();
		
		combo_box = new JComboBox();

		card_layout = new CardLayout();
		card_panel = new JPanel(card_layout);

		combo_box.addItem(NONE_STR);
		card_panel.add(new JPanel(), NONE_STR);
		for(int i=0; i<xforms.length; i++) {
			combo_box.addItem(xforms[i].getLabel());
			card_panel.add(
				new JScrollPane(xforms[i].getGUI()),
				xforms[i].getLabel());
		}

		combo_box.addActionListener(this);

		gui_panel.setLayout(new BorderLayout());
		gui_panel.add(combo_box, BorderLayout.NORTH);
		gui_panel.add(card_panel, BorderLayout.CENTER);

		return gui_panel;
	}

	public void actionPerformed(ActionEvent evt) {
		setXform((String)combo_box.getSelectedItem());
	}

	public void setXform(String name) {
//System.out.println("setXform("+name+")");
		if(xforms == null) return;
		if(name == null || name.equals(NONE_STR)) name = null;
		if(gui_panel != null) {
			String sel_obj = (String)combo_box.getSelectedItem();
			if(
				(sel_obj==null && name!=null) ||
				(sel_obj!=null && !sel_obj.equals(name))
			) {
				combo_box.setSelectedItem(name);
			}
		}

		xf = lookupXform(name);
		if(xf == null) {
			if(gui_panel != null) {
				card_layout.show(card_panel, NONE_STR);
			}
	
			try {
				setObject("XFORM_TYPE", NONE_STR);
			} catch(Exception e) {
				e.printStackTrace();
			}
			removeParameter("XFORM_PARAMS");
		} else {
			if(gui_panel != null) {
				card_layout.show(card_panel, xf.getLabel());
			}

			try{
				setObject("XFORM_TYPE", name);
			} catch(Exception e) {
				e.printStackTrace();
			}
			removeParameter("XFORM_PARAMS");
			addParameter(xf);
		}
	}

	private XformSkeleton lookupXform(String name) {
		if(name == null) return null;
		for(int i=0; i<xforms.length; i++) {
			if(xforms[i].getLabel().equals(name)) {
				return xforms[i];
			}
		}
		return null;
	}

	public String getXform() {
		if(xf == null) return null;
		return xf.getLabel();
	}

	public void parameterChanged(Object src) {
		if(ignore_change) return;
		ignore_change = true;

		setXform((String)getObject("XFORM_TYPE"));

		if(listener != null) listener.parameterChanged(this);

		ignore_change = false;
	}

	public boolean isXformNull() {
		return xf == null;
	}

	public String getLabel() { return "Chooser"; }

	public void iterate(double[] coord) { 
		if(xf == null) return;
		xf.iterate(coord);
	}

	public void copy(XformChooser source) {
		try {
			setParams(source.getParams());
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	public Object[] interpolate(Object[] seq_in, double Fpos) {
		int Ipos = (int)Math.floor(Fpos);
		int left_idx = 
			Ipos<0 ? 0 :
			Ipos >= seq_in.length ? seq_in.length-1 :
			Ipos;
		Ipos++;
		int right_idx = 
			Ipos<0 ? 0 :
			Ipos >= seq_in.length ? seq_in.length-1 :
			Ipos;

		String left_type = (String)((HashMap)
			seq_in[left_idx]).get("XFORM_TYPE");
		String right_type = (String)((HashMap)
			seq_in[right_idx]).get("XFORM_TYPE");
//System.out.println("lt="+left_type+", rt="+right_type);
		if(!left_type.equals(right_type)) {
			HashMap<String, Object> left_params = 
				new HashMap<String, Object>();
			HashMap<String, Object> right_params =
				new HashMap<String, Object>();
			left_params.put("XFORM_TYPE", left_type);
			left_params.put("XFORM_PARAMS",
				((HashMap)seq_in[left_idx]).get("XFORM_PARAMS"));
			right_params.put("XFORM_TYPE", right_type);
			right_params.put("XFORM_PARAMS",
				((HashMap)seq_in[right_idx]).get("XFORM_PARAMS"));
			return new Object[] { left_params, right_params };
		}

		while(left_idx>0) {
			left_idx--;
			left_type = (String)((HashMap)
				seq_in[left_idx]).get("XFORM_TYPE");
			if(!left_type.equals(right_type)) {
				left_idx++;
				break;
			}
		}
		while(right_idx<seq_in.length-1) {
			right_idx++;
			right_type = (String)((HashMap)
				seq_in[right_idx]).get("XFORM_TYPE");
			if(!left_type.equals(right_type)) {
				right_idx--;
				break;
			}
		}

		left_type = (String)((HashMap)
			seq_in[left_idx]).get("XFORM_TYPE");
		right_type = (String)((HashMap)
			seq_in[right_idx]).get("XFORM_TYPE");
//System.out.println("li="+left_idx+", ri="+right_idx);
//System.out.println("lt="+left_type+", rt="+right_type);
		if(!left_type.equals(right_type)) {
			throw new IllegalStateException();
		}

		HashMap<String, Object> left_params = 
			new HashMap<String, Object>();
		HashMap<String, Object> right_params =
			new HashMap<String, Object>();
		left_params.put("XFORM_TYPE", left_type);
		right_params.put("XFORM_TYPE", right_type);
	
		AdjustableParameter p = lookupXform(left_type);
		if(p == null) {
			return new Object[] { left_params, left_params };
		}
//System.out.println("pc="+p.getClass().getName());

		Object[] seq_p = new Object[right_idx - left_idx + 1];
		for(int j=0; j<seq_p.length; j++) {
			int k = j + left_idx;
//System.out.println("seq_in["+k+"]="+seq_in[k].getClass().getName());
			seq_p[j] = ((HashMap)seq_in[k]).get("XFORM_PARAMS");
		}
		Object[] interp = p.interpolate(seq_p, Fpos - (double)left_idx);
		Object left_p = interp[0];
		Object right_p = interp[1];
//if(left_p != right_p) System.out.println("maps differ: "+p.getID()+": "+left_p+","+right_p);
		left_params.put("XFORM_PARAMS", left_p);
		right_params.put("XFORM_PARAMS", right_p);
		if(left_p == right_p) {
//System.out.println("left_p="+left_p);
			return new Object[] { left_params, left_params };
		} else {
			return new Object[] { left_params, right_params };
		}
	}

	// overridden because params must be read in this order
	public void thaw(String in_str) throws Exception {
		HashMap<String, String> map = IndentReader.readIndentString(in_str);
		getParameter("XFORM_TYPE").thaw(map.get("XFORM_TYPE"));
		setXform((String)getObject("XFORM_TYPE"));
		if(getParameter("XFORM_PARAMS") != null)
			getParameter("XFORM_PARAMS").thaw(map.get("XFORM_PARAMS"));
	}

	public void setParams(Object new_params) throws Exception {
		AdjustableParameter p = getParameter("XFORM_TYPE");
		Object new_val = ((HashMap)new_params).get(p.getID());
//System.out.println("xft="+new_val);
		if(new_val != null) p.setParams(new_val);

		setXform((String)getObject("XFORM_TYPE"));

		p = getParameter("XFORM_PARAMS");
		if(p != null) {
			new_val = ((HashMap)new_params).get(p.getID());
//System.out.println("xfp="+new_val);
			if(new_val != null) p.setParams(new_val);
		}

		super.parameterChanged(this);
	}

	public String toString() {
		return "XformChooser["+getXform()+"]";
	}
}
