import java.util.*;
import java.awt.*;
import javax.swing.*;

public class ParameterGroup implements AdjustableParameter, ParameterListener {
	String id;
	String label;
	String tooltip;
	boolean has_border;
	java.util.List<ParameterListener> listeners = 
		new ArrayList<ParameterListener>();
	java.util.List<AdjustableParameter> parameters = Collections.synchronizedList(
		new ArrayList<AdjustableParameter>());
	JComponent gui;
	boolean ignore_events;

	public ParameterGroup(String id, String label, String tooltip) {
		this.id = id;
		this.label = label;
		this.tooltip = tooltip;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	// must be called before createGUIComponent
	public void setBorder(boolean state) {
		this.has_border = state;
	}

	public void addParameter(AdjustableParameter p) {
		parameters.add(p);
		p.addParameterListener(this);
	}

	public void removeParameter(String id) {
		AdjustableParameter p = getParameter(id);
		if(p != null) {
			p.removeParameterListener(this);
			parameters.remove(p);
		}
	}

	public AdjustableParameter getParameter(String id) {
		for(AdjustableParameter p : parameters) {
			if(p.getID().equals(id)) return p;
		}
		return null;
	}

	public void addParameterListener(ParameterListener l) {
		if(l == null) return;
		listeners.add(l);
	}

	public void removeParameterListener(ParameterListener l) {
		listeners.remove(l);
	}
	
	public JComponent createGUIComponent() { 
		if(gui != null) return gui;

		JPanel panel = new JPanel();
		//panel.setLayout(new GridLayout(0, 1));
		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
		for(AdjustableParameter p : parameters) {
			panel.add(p.createGUIComponent());
		}

		if(has_border) {
			if(label != null) panel.setBorder(
				BorderFactory.createTitledBorder(label));
			else panel.setBorder(
				BorderFactory.createEtchedBorder());
		}
		
		this.gui = panel;
		return gui;
	}

	public String getID() { return id; }

	public String getLabel() { return label; }

	public String getTooltip() { return tooltip; }

	public void setParams(Object new_params) throws Exception {
		ignore_events = true;
		for(AdjustableParameter p : parameters) {
			Object new_val = ((HashMap)new_params).get(p.getID());
			if(new_val != null) p.setParams(new_val);
		}
		ignore_events = false;
		parameterChanged(this);
	}

	public Object getParams() {
		HashMap<String, Object> params = new HashMap<String, Object>();
		for(AdjustableParameter p : parameters) {
			params.put(p.getID(), p.getParams());
		}
		return params;
	}

	public Object[] interpolate(Object[] seq_in, double pos) {
		HashMap<String, Object> left_params = new HashMap<String, Object>();
		HashMap<String, Object> right_params = new HashMap<String, Object>();
		boolean maps_differ = false;
		for(AdjustableParameter p : parameters) {
			Object[] seq_p = new Object[seq_in.length];
			for(int j=0; j<seq_in.length; j++) {
//	System.out.println("seq_in["+j+"]="+seq_in[j].getClass().getName());
				seq_p[j] = ((HashMap)seq_in[j]).get(p.getID());
			}
			Object[] interp = p.interpolate(seq_p, pos);
			Object left_p = interp[0];
			Object right_p = interp[1];
			if(left_p != right_p) maps_differ = true;
if(left_p != right_p) System.out.println("maps differ: "+p.getID()+": "+left_p+","+right_p);
			left_params.put(p.getID(), left_p);
			right_params.put(p.getID(), right_p);
		}
		if(!maps_differ) right_params = left_params;
		return new Object[] { left_params, right_params };
	}

	public void mutate(AdjustableParameter source, 
	double exp, double mult, boolean allow_gaps) {
		// FIXME
//		for(AdjustableParameter p : parameters) {
		for(int i=0; i<parameters.size(); i++) {
			AdjustableParameter p = (AdjustableParameter)parameters.get(i);
			AdjustableParameter src_p = ((ParameterGroup)source).
				getParameter(p.getID());
			p.mutate(src_p, exp, mult, allow_gaps);
		}
	}

	public String freeze() {
		String out = "";
		for(AdjustableParameter p : parameters) {
			out += p.getID()+"\n";
			out += IndentReader.addTabToEveryLine(p.freeze());
		}
		return out;
	}

	public void thaw(String in_str) throws Exception {
		HashMap<String, String> map = IndentReader.readIndentString(in_str);
		for(String key : map.keySet()) {
			getParameter(key).thaw(map.get(key));
		}
	}

	public void parameterChanged(Object src) {
		if(ignore_events) return;
		for(ParameterListener l : listeners) {
			l.parameterChanged(this);
		}
	}

	public double getDouble(String id) {
		return ((Double)getParameter(id).getParams()).doubleValue();
	}

	public void setDouble(String id, double v) {
		try {
			getParameter(id).setParams(new Double(v));
		} catch(Exception e) {
			throw new IllegalStateException("param "+id+" cannot accept a Double");
		}
	}

	public boolean getBoolean(String id) {
		return ((Boolean)getParameter(id).getParams()).booleanValue();
	}

	public void setObject(String id, Object o) throws Exception {
		getParameter(id).setParams(o);
	}

	public Object getObject(String id) {
		if(getParameter(id) == null) return null;
		return getParameter(id).getParams();
	}
}
