import java.applet.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public final class IFS extends Applet {
	public static final int NUM_XFORMS = 4;

	public static void main(String[] args) {
		IFS ifs = new IFS();
		if(args.length == 0) {
			ifs.init2(false, null);
			ifs.start();
		} else if(args.length == 5) {
			try {
				StandaloneImageGenerator gen =
					new StandaloneImageGenerator(
					Integer.parseInt(args[0]),
					Integer.parseInt(args[1]),
					Integer.parseInt(args[2]),
					args[3],
					readFile(args[4]));
			} catch(Exception e) {
				e.printStackTrace();
			}
			System.exit(0);
		} else if(args.length >= 7) {
			try {
				String[] keyframes = new String[args.length-5];
				for(int i=0; i<keyframes.length; i++)
					keyframes[i] = readFile(args[5+i]);
				StandaloneImageGenerator gen =
					new StandaloneImageGenerator(
					Integer.parseInt(args[0]),
					Integer.parseInt(args[1]),
					Integer.parseInt(args[2]),
					Integer.parseInt(args[3]),
					args[4],
					keyframes);
			} catch(Exception e) {
				e.printStackTrace();
			}
			System.exit(0);
		} else {
			System.out.println("Usage: java IFS <width> <height> <num_iter> <out.ppm> <save.ifs>");
			System.out.println("Or:    java IFS <width> <height> <num_iter> <frames_per_keyframe> <out-base> <key_a.ifs> <key_b.ifs> ...");
			System.exit(0);
		}
	}

	public void init() {
		try {
			javax.swing.SwingUtilities.invokeAndWait(new Runnable() {
				public void run() {
					init2(true, null);
				}
			});
		} catch (Exception e) {
			System.err.println("createGUI didn't successfully complete");
		}
	}

	public void init2(boolean is_applet, String init_params) {
		new StartupFrame(is_applet, init_params);
	}

	public void start() {}
	public void stop() {}
	public void destroy() {}

	private static String readFile(String fn) throws Exception {
		FileInputStream fh = new FileInputStream(fn);
		byte[] buf = new byte[10000];
		int len = fh.read(buf);
		fh.close();
		if(len == buf.length) throw new Exception("line too long in input: "+fn);
		return new String(buf, 0, len);
	}
}

