/*

  Name      :  File System
  Hardware  :  UALFAT SD Card
  Notes     :  microSD card access via SPI. 
  
  This is where music and graphic files are stored.

  references:
  http://www.ghielectronics.com/product/102

*/

void init_fat(){
  // tell disk module to enter SPI mode on powerup.
  clockOn();
  slaveOn();
  digitalWrite(FAT_RESET_PIN,0);  
  delayMicro(500);
  digitalWrite(FAT_RESET_PIN,1);  
  delayMicro(500);
  slaveOff();

  // enable SPI Master, MSB, SPI mode 0, FOSC/4
  SPCR = B01011100;  // initialize SPI mode
  
  // display and flush banner
  printResult("banner time");
  for (byte i = 0; i <= 88; i++)
  {
    printResult(GHI_GetC());
  } 
  delayMicro(10);
  printResult("\nversion");
  GHI_PutS("V\r");
  GHI_GetResponse(16);
  printResult("\ninit and mount");
  GHI_PutS("I\r");
  GHI_GetResponse(4);

  printResult("\ninit files and folders list");
  GHI_PutS("@\r");
  GHI_GetResponse(4);
}

// send single byte command to module
void GHI_PutC(int8 ch){
  slaveOff();
  spi_transfer(ch);
  slaveOn();  
}

// send string array commands to module
void GHI_PutS(char * str){
  int8 c;	
  c=0;
  while(str[c]){
    GHI_PutC(str[c++]);   
  }
}

// keep trying until we get a byte returned
byte GHI_GetC(void){
  slaveOff();

  byte c;
  do{
    c = spi_transfer(0xFF);  // get byte from module
  }
  while(c==0xff);            // we may need to add timeout here

  // check for NDT and HDT
  if(c == 0xfe)              // NDT
  {
    c = spi_transfer(0xFF);  // get byte from module
    if(c == 0xFE)
      return 0xfe;
    else if(c == 0)
      return 0xff; 
    else
      return 0;              // this should never happen!!!!
  }
  slaveOn();  
  return c;		
}

// handle responses such as $00000000<CR>!00<CR>
void GHI_GetResponse(byte rlength){
  do
  {
    GHI_GetC();
  }
  while(--rlength);
}

// ualFAT needs to slow down 
byte spi_transfer(byte data){
  SPDR = data;			  // start the transmission
  delayMicroseconds(6);           // originally 3
  while (!(SPSR & (1<<SPIF)));    // wait the end of the transmission
  return SPDR;			  // return the received byte, we don't need that
}

// FM & PSG chips are fed data via this function at highspeed
byte spi_transfer_nodelay(byte data){
  SPSR = (1<<SPI2X);              // set prescaler bits - this speeds up transmission
  SPDR = data;			  // start the transmission
  while (!(SPSR & (1<<SPIF))){};  // wait the end of the transmission
  SPSR = (0<<SPI2X);              // set prescaler bits - restore transmission speeds
  return SPDR;			  // return the received byte, we don't need that
}



