/*

 Name      :  Rotozoomer
 Notes     :  A rotating and zooming bitmap.
 
 2D rotozoomers are a combination of rotation and scaling transformations
 Could possibly be the starting point for polygon texturing routines
 utilized in 3D renderers.  One of the most famous rotozoomers is the one 
 from Second Reality / Future Crew which this is based on.
 
 references:
 http://www.student.kuleuven.be/~m0216922/CG/xortexture.html
 
 */

// 32 x 32 texture from unreal.  This occupies 1024 bytes of program space.
const unsigned char meanman_32[] PROGMEM = {
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x01,0x0a,0x13,0x5c,0x66,0xae,0xae,0x66,0x5d,0x54,0x0b,0x01,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x0b,0x14,0x5d,0x66,0xae,0xb7,0xb7,0xb7,0xb7,0xae,0x66,
  0x66,0x5d,0x0b,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9b,0x52,
  0x08,0x09,0x00,0x00,0x00,0x0b,0x5d,0x5d,0x65,0x66,0xae,0xb7,0xb7,0xb7,0xb7,
  0xae,0x66,0x65,0x5d,0x5c,0x14,0x02,0x00,0x00,0x09,0x49,0x9b,0x52,0x00,0x00,
  0x52,0x51,0x08,0x09,0x00,0x00,0x0b,0x14,0x5d,0x5d,0x65,0x66,0xae,0xaf,0xaf,
  0xb7,0xaf,0xae,0x66,0x65,0x5d,0x5d,0x14,0x0b,0x00,0x00,0x09,0x49,0x52,0x51,
  0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x0b,0x14,0x5d,0x5d,0x65,0x66,0x66,
  0xae,0xae,0xae,0xae,0xa6,0x66,0x65,0x5d,0x5d,0x14,0x14,0x02,0x00,0x00,0x00,
  0x08,0x00,0x00,0x00,0x08,0x5a,0x00,0x00,0x00,0x01,0x0b,0x14,0x5d,0x5d,0x5d,
  0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x5d,0x5d,0x5d,0x14,0x14,0x0b,0x00,
  0x00,0x00,0x9a,0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x0b,0x14,0x5d,
  0x5d,0x5d,0x5d,0x5d,0x5d,0x5d,0x5d,0x65,0x5d,0x5d,0x5d,0x5d,0x5d,0x14,0x14,
  0x0b,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x0b,
  0x14,0x5c,0x5d,0x5d,0x5d,0x5d,0x5d,0x5d,0x5d,0x5d,0x5d,0x5d,0x5d,0x5d,0x5c,
  0x14,0x0b,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x5d,
  0x01,0x02,0x0b,0x14,0x5c,0x5d,0x5d,0x5d,0x5d,0x5d,0x5d,0x5d,0x5d,0x5d,0x5d,
  0x5c,0x14,0x0b,0x0b,0x01,0x54,0x0a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x01,0x14,0x14,0x0a,0x14,0x14,0x14,0x14,0x5c,0x54,0x14,0x5c,0x5c,0x54,0x5c,
  0x5c,0x5c,0x14,0x14,0x14,0x0b,0x13,0x5d,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x02,0x14,0x0b,0x5d,0x66,0x5d,0x14,0x14,0x14,0x14,0x14,0x14,
  0x14,0x14,0x14,0x14,0x5c,0x65,0x5d,0x0b,0x14,0x0a,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x0b,0x02,0x0b,0x14,0x65,0x66,0x65,0x5d,0x5d,
  0x54,0x14,0x5d,0x5d,0x5d,0x66,0x65,0x14,0x0b,0x02,0x0b,0x01,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0b,0x0b,0x02,0x02,0x0b,0x25,0x66,
  0x5d,0x5d,0x14,0x14,0x5d,0x5d,0x66,0x66,0x0b,0x02,0x02,0x0a,0x13,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x0b,0x5c,0x14,0x02,
  0x0b,0x0b,0x02,0x13,0x5d,0x5c,0x0b,0x02,0x0b,0x13,0x02,0x14,0x5d,0x0b,0x14,
  0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x5c,
  0x66,0x65,0x54,0x54,0x5d,0x5d,0x66,0x66,0x5d,0x5d,0x5c,0x54,0x5d,0x66,0x5d,
  0x0a,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x02,0x14,0x65,0x66,0x66,0x65,0x5d,0x66,0x66,0x5d,0x5d,0x66,0x66,0x65,
  0x5c,0x0b,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x01,0x0b,0x14,0x14,0x5c,0x65,0xa6,0x66,0x65,0x5d,0x14,
  0x54,0x0b,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x0b,0x13,0x14,0x14,0x5c,0xae,0xae,0x5c,
  0x13,0x14,0x13,0x14,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x0b,0x13,0x5d,0x5d,0x0b,0x5c,
  0x5d,0x0a,0x5d,0x5d,0x14,0x0b,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x00,
  0x00,0x00,0x00,0x52,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0a,0x14,0x14,0x5d,
  0x5c,0x02,0x02,0x54,0x5d,0x14,0x14,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x49,0x00,0x00,0x00,0x09,0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,
  0x14,0x14,0x14,0x14,0x14,0x54,0x14,0x14,0x5d,0x0a,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x52,0x49,0x00,0x09,0x9b,0x5a,0x09,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x01,0x5d,0x14,0x14,0x14,0x13,0x14,0x14,0x5d,0x14,0x00,0x00,0x00,0x00,
  0x00,0x08,0x49,0x52,0x9b,0x52,0x00,0x00,0x51,0x49,0x00,0x51,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x0a,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x01,0x00,0x00,
  0x00,0x00,0x00,0x00,0x08,0x00,0x49,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x01,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00};

void rotozoomer(byte x, byte y, byte w, byte h, byte type){
  byte timeDisplacement=110;     // number of frames to run
  byte page=0;                   // double buffer counter
  float angle=1.0;               // rotation factor
  float scalee=1;                // zoom factor 
  float dscalee=0.05;            // zoom direction: in or out

  do{
    page = timeDisplacement & 1; // fast modulo operation using bitwise AND (same as: timeDisplacement % 2)
    switchWritePage(page);

    int soffs;
    float tx,ty,txx=0,tyy=0,ca,sa;

    // slow
    // ca=scalee*cos(angle);
    // sa=scalee*sin(angle);

    // fast
    // ca=scalee*fastCoSine(angle);
    // sa=scalee*fastSine(angle);

    // fastest
    ca=scalee*fpu_cos(angle);
    sa=scalee*fpu_sin(angle);

    setupIMG(x,y,w,h);
    for (byte y=0;y<h;y++) {
      ty=tyy+=ca;
      tx=txx+=-sa;
      for (byte x=0;x<w;x++) {
        vgm();
        soffs=byte(ty+=sa)<<5;
        soffs+=byte(tx+=ca);
        VGA_sendCommand((type)? pgm_read_byte(&meanman_32[soffs&0x3ff]): color(int(tx)^int(ty),0,0));
      }    
    }
    VGA_GetResponse();

    // its math time
    angle  += 0.05; 
    scalee += (scalee<=0.36 || scalee>=3.6) ? dscalee*=-1: dscalee; 
    switchViewPage(page);
  }
  while(--timeDisplacement);
}

