/*

 Name      :  Fire
 Notes     :  Flames rising up the screen
 
 The fire effect has been used quite often for oldskool demos. 
 First you create a palette of 256 colors ranging from red to
 yellow (including black). For every frame, calculate each row 
 of pixels based on the two rows below it: The value of each pixel,
 becomes the sum of the 3 pixels below it (one directly below, one 
 to the left, and one to the right), and one pixel directly two 
 rows below it. Then divide the sum so that the fire dies out 
 as it rises.
 
 references:
 http://www.student.kuleuven.be/~m0216922/CG/fire.html 
 
 */

// burninate them pixels
void fire(byte px, byte py, byte w, byte h){ 
  byte fire[w+1][h+1];        // This will contain pixels used to calculate the fire effect
  byte sizeMultiplierW = 6;   // horizontal size of giant pixels
  byte sizeMultiplierH = 4;   // vertical size of giant pixels
  byte timeDisplacement=180;  // number of frames to run

  // generate flame color palette in RGB. need 256 bytes available memory
  byte i = 64;
  byte flame_palette[255];    
  do
  {
    flame_palette[i]  = color(i<<2,0,0);          // black to red
    flame_palette[i+63]  = color(255,i<<2,0);     // red to yellow
    flame_palette[i+127]  = color(255,255,i<<2);  // yellow to white
    flame_palette[i+191]  = color(255,255,255);   // white
  }
  while(--i); // keep going until we reach 0

  do{    
    for(byte x = 0; x <= w-1; x++){
      fire[x][h] = (byte)random(255);           // Randomize the bottom row of the fire buffer
    }

    // Do the fire calculations for every pixel, from top to bottom
    for (byte y = 0; y <= h-1; y++) {
      byte calc2 = (y + 1) & h;
      byte calc5 = (y + 2) & h;
      for(byte x = 0; x <= w-1; x++) {
        // Add pixel values around current pixel
        fire[x][y] =
          ((fire[(x - 1) & w][calc2]
          + fire[x&w][calc2]
          + fire[(x + 1) & w][calc2]
          + fire[x&w][calc5]) << 5) / 140;
        vgm();
        // Output everything to screen using our palette colors
        rect(px+(x*sizeMultiplierW), py+(y*sizeMultiplierH), px+(x*sizeMultiplierW)+sizeMultiplierW, py+(y*sizeMultiplierH)+sizeMultiplierH,flame_palette[fire[x][y]]);      
      }
    }
  }
  while(--timeDisplacement);
}

