uniform float uTimer;
uniform vec3 uColor1;
uniform vec3 uColor2;
uniform sampler2D uTexture;
uniform sampler2D uTunnelTexture;

void main() {
	vec2 coordinate = gl_TexCoord[0].xy;
	float distance = texture2D(uTexture, coordinate).r;

	vec2 coordinate2 = gl_TexCoord[1].xy;

	float timer = uTimer * 0.5;
	float angle = sin(timer * 1.0);
	float scale = 0.5 + 0.3 * sin(timer * 1.1);
	vec2 position = vec2(0.5) + vec2(sin(timer * 0.3) * 0.5, cos(timer * 0.2) * 0.5);
	vec2 offset = coordinate2 - position;
	offset = scale * vec2(offset.x * cos(angle) + offset.y * sin(angle),
	                      offset.x * sin(angle) - offset.y * cos(angle));
	offset = offset + position;
	float size = texture2D(uTunnelTexture, offset).r;
	float checkDistance = 0.4 + 0.5 * size;

	float inside = clamp((checkDistance - distance) * 10.0, 0.0, 1.0);
	vec4 color1 = vec4(uColor1, 1.0);
	vec4 color2 = vec4(uColor2, 1.0);
	gl_FragColor = mix(color1, color2, inside);
}
