uniform float uTimer;
varying vec4 diffuse;
varying vec3 lightDir, halfVector;
varying float alpha;

void main() {
	vec2 coordinate = (gl_TexCoord[0].xy - vec2(0.5, 0.5)) * 2.0;
	float distance = dot(coordinate, coordinate);

	vec3 n, halfV;
	float NdotL, NdotHV;
	float specular = 0.0;
	
	// The ambient term will always be present
	vec4 ambient = vec4(0);
	vec4 color = ambient;

	float repeat = 5.0;
	float timerScale = 5.0;
	vec2 distort = vec2(sin(coordinate.x * repeat * 0.83 + uTimer * timerScale * 0.77) * cos(coordinate.y * repeat),
	                    sin(coordinate.x * repeat - uTimer * timerScale) + cos(coordinate.y * repeat * 1.37 - uTimer * timerScale * 0.97));
	vec3 normal = vec3(distort * 0.2, 1.0);
	
	// a fragment shader can't write a varying variable, hence we need a new variable to store the normalized interpolated normal
	n = normalize(normal);

	// compute the dot product between normal and ldir
	NdotL = max(dot(n, lightDir), 0.0);

	if (NdotL > 0.0) {
		color += diffuse * NdotL;
		halfV = normalize(halfVector);
		NdotHV = max(dot(n, halfV), 0.0);
		//specular = pow(NdotHV, gl_FrontMaterial.shininess);
		specular = pow(NdotHV, 400.0);
		color += gl_FrontMaterial.specular *
		         gl_LightSource[0].specular * 
		         specular;
	}

	float alpha2 = pow(1.0 - distance, 0.6);
	//color.rgb = vec3(1.0, 1.0, 1.0);

	//gl_FragColor = vec4(color.rgb, mix(alpha, 1.0, specular));
	gl_FragColor = vec4(color.rgb, alpha2);
}
