varying vec4 diffuse, ambient;
varying vec3 normal, lightDir, halfVector;
varying float alpha;
varying vec3 ufoLightPosition;

uniform sampler2D texture;

void main() {
	vec3 n, halfV;
	float NdotL, NdotHV;
	float specular = 0.0;
	
	// The ambient term will always be present
	vec4 color = ambient;
	
	// a fragment shader can't write a varying variable, hence we need a new variable to store the normalized interpolated normal
	n = normalize(normal);
	
	// compute the dot product between normal and ldir
	NdotL = max(dot(n, lightDir), 0.0);

	color += diffuse * NdotL;

	vec4 textureColor = texture2D(texture, gl_TexCoord[0].st);
	color.rgb *= textureColor.rgb;

	halfV = normalize(halfVector);
	NdotHV = max(dot(n, halfV), 0.0);
	specular = pow(NdotHV, gl_FrontMaterial.shininess);
	color += gl_FrontMaterial.specular *
					 gl_LightSource[0].specular *
					 specular;

	float ufoLightDistance = length(ufoLightPosition);
	vec3 ufoLightColor = gl_LightSource[1].diffuse.rgb * max(0.3, dot(normalize(ufoLightPosition), n));
	color.rgb += ufoLightColor * 2.0 / (2.0 + ufoLightDistance * ufoLightDistance);

	gl_FragColor = vec4(color.rgb, mix(alpha, 1.0, specular));
}
