/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server.states.match;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lonelycoders.ufohippa.network.EmptyState;
import lonelycoders.ufohippa.network.State;
import lonelycoders.ufohippa.network.StateManager;
import lonelycoders.ufohippa.server.ServerCommunicator;
import lonelycoders.ufohippa.server.states.match.ServerMatchStartingState;
import lonelycoders.ufohippa.server.states.match.ServerResultsState;
import lonelycoders.ufohippa.server.states.match.ServerRoundState;

public class ServerMatchStateManager
extends StateManager {
    private final ServerResultsState resultsState;
    private final ServerMatchStartingState matchStartingState;
    private final ServerRoundState roundState;
    private final State backToLobbyState = new EmptyState("Back to lobby");
    private State lobbyState;

    public ServerMatchStateManager(ServerCommunicator serverCommander) {
        super("Match state manager");
        this.resultsState = new ServerResultsState(serverCommander, this.backToLobbyState);
        this.roundState = new ServerRoundState(serverCommander, this.resultsState);
        this.resultsState.setNextRoundState(this.roundState);
        this.matchStartingState = new ServerMatchStartingState(serverCommander, this.roundState);
    }

    public ServerRoundState getRoundState() {
        return this.roundState;
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.setState(this.matchStartingState);
        }
    }

    @Override
    protected Set<State> getAvailableStates() {
        return new HashSet<State>(Arrays.asList(this.matchStartingState, this.roundState, this.resultsState, this.backToLobbyState));
    }

    @Override
    protected Map<State, State> getFinalStates() {
        HashMap<State, State> finalStates = new HashMap<State, State>();
        finalStates.put(this.backToLobbyState, this.lobbyState);
        return finalStates;
    }

    public void setLobbyState(State lobbyState) {
        this.lobbyState = lobbyState;
    }
}

