/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server.states.match;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lonelycoders.ufohippa.game.level.LevelDescriptor;
import lonelycoders.ufohippa.game.util.Vector2;
import lonelycoders.ufohippa.server.model.PlayerInfo;

public class RoundStartInfo {
    private final Vector2[] startingPositions;
    private final String startTag;

    public RoundStartInfo(LevelDescriptor level, List<PlayerInfo> players) {
        int playerCount = players.size();
        Vector2[] possibleStartingPositions = level.load().getStartingPositions();
        assert (possibleStartingPositions.length >= playerCount);
        List<Vector2> possibleStartingPositionsList = Arrays.asList(Arrays.copyOf(possibleStartingPositions, playerCount));
        Collections.shuffle(possibleStartingPositionsList);
        this.startingPositions = possibleStartingPositionsList.toArray(new Vector2[playerCount]);
        int tagIndex = (int)(Math.random() * (double)playerCount);
        this.startTag = players.get(tagIndex).getName();
    }

    public Vector2[] getStartingPositions() {
        return this.startingPositions;
    }

    public String getStartTag() {
        return this.startTag;
    }
}

