/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import lonelycoders.ufohippa.game.level.LevelDescriptor;
import lonelycoders.ufohippa.server.model.BasicSettings;
import lonelycoders.ufohippa.server.model.PlayerInfo;

public class AllServerSettings {
    private BasicSettings basicSettings = new BasicSettings();
    private final List<LevelDescriptor> levels = new ArrayList<LevelDescriptor>();
    private final List<PlayerInfo> players = new ArrayList<PlayerInfo>();
    private final Collection<Listener> listeners = new HashSet<Listener>();

    public void setBasicSettings(BasicSettings basicSettings) {
        this.basicSettings = basicSettings;
        this.fireBasicSettingsChanged();
    }

    public void setLevels(LevelDescriptor[] newLevels) {
        this.levels.clear();
        this.levels.addAll(Arrays.asList(newLevels));
        this.fireLevelSettingsChanged();
    }

    public Collection<LevelDescriptor> getLevels() {
        return Collections.unmodifiableCollection(this.levels);
    }

    public List<PlayerInfo> getPlayers() {
        return this.players;
    }

    public void addLevel(LevelDescriptor level) {
        this.levels.add(level);
        this.fireLevelSettingsChanged();
    }

    public void removeLevel(LevelDescriptor level) {
        this.levels.remove(level);
        this.fireLevelSettingsChanged();
    }

    public void setPlayers(PlayerInfo[] newPlayers) {
        this.players.clear();
        this.players.addAll(Arrays.asList(newPlayers));
        this.firePlayersSettingsChanged();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
        this.fireBasicSettingsChanged(listener);
        this.fireLevelSettingsChanged(listener);
        this.firePlayersSettingsChanged(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void fireBasicSettingsChanged() {
        for (Listener listener : this.listeners) {
            this.fireBasicSettingsChanged(listener);
        }
    }

    private void fireBasicSettingsChanged(Listener listener) {
        listener.basicSettingsChanged(this.basicSettings.getMaxPlayers(), this.basicSettings.getPlayingTime(), this.basicSettings.getAiPlayers(), this.basicSettings.isBonusItems(), this.basicSettings.isPublicGame(), this.basicSettings.isAllowJoiningDuringGame());
    }

    private void fireLevelSettingsChanged() {
        for (Listener listener : this.listeners) {
            this.fireLevelSettingsChanged(listener);
        }
    }

    private void fireLevelSettingsChanged(Listener listener) {
        listener.levelsChanged(this.levels);
    }

    private void firePlayersSettingsChanged() {
        for (Listener listener : this.listeners) {
            this.firePlayersSettingsChanged(listener);
        }
    }

    private void firePlayersSettingsChanged(Listener listener) {
        listener.playersChanged(this.players);
    }

    public BasicSettings getBasicSettings() {
        return this.basicSettings;
    }

    public static interface Listener {
        public void basicSettingsChanged(int var1, int var2, int var3, boolean var4, boolean var5, boolean var6);

        public void levelsChanged(List<LevelDescriptor> var1);

        public void playersChanged(List<PlayerInfo> var1);
    }
}

