/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server;

import java.util.ArrayList;
import java.util.List;
import lonelycoders.ufohippa.network.commands.match.RoundUpdateCommand;

public class UpdateInfo {
    private List<RoundUpdateCommand.PlayerData> playerDatas = new ArrayList<RoundUpdateCommand.PlayerData>();
    private List<RoundUpdateCommand.BulletShootData> shootDatas = new ArrayList<RoundUpdateCommand.BulletShootData>();
    private List<RoundUpdateCommand.UfoCollision> ufoCollisions = new ArrayList<RoundUpdateCommand.UfoCollision>();
    private List<RoundUpdateCommand.BulletHit> bulletHits = new ArrayList<RoundUpdateCommand.BulletHit>();
    private List<SoundEffect> soundEffects = new ArrayList<SoundEffect>();
    private boolean teleported;
    private boolean tagChanged;

    public void addPlayerData(RoundUpdateCommand.PlayerData playerData) {
        this.playerDatas.add(playerData);
    }

    public void bulletShot(RoundUpdateCommand.BulletShootData shootData) {
        this.shootDatas.add(shootData);
    }

    public void ufosCollided(RoundUpdateCommand.UfoCollision collision) {
        this.ufoCollisions.add(collision);
    }

    public void bulletHit(RoundUpdateCommand.BulletHit bulletHit) {
        this.bulletHits.add(bulletHit);
    }

    public void addSoundEffect(SoundEffect soundEffect) {
        this.soundEffects.add(soundEffect);
    }

    public boolean isEmpty() {
        return this.playerDatas.isEmpty() && this.shootDatas.isEmpty() && this.ufoCollisions.isEmpty() && this.bulletHits.isEmpty() && this.soundEffects.isEmpty();
    }

    public List<RoundUpdateCommand.PlayerData> getPlayerDatas() {
        return this.playerDatas;
    }

    public List<RoundUpdateCommand.BulletShootData> getShootDatas() {
        return this.shootDatas;
    }

    public List<RoundUpdateCommand.UfoCollision> getUfoCollisions() {
        return this.ufoCollisions;
    }

    public List<RoundUpdateCommand.BulletHit> getBulletHits() {
        return this.bulletHits;
    }

    public List<SoundEffect> getSoundEffects() {
        return this.soundEffects;
    }

    public void setTeleported() {
        this.teleported = true;
    }

    public boolean isTeleported() {
        return this.teleported;
    }

    public void setTagChanged() {
        this.tagChanged = true;
    }

    public boolean wasTagChanged() {
        return this.tagChanged;
    }

    public static enum SoundEffect {
        WALL_COLLISION,
        TELEPORT;

    }
}

