/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import lonelycoders.ufohippa.game.ai.AIController;
import lonelycoders.ufohippa.game.ai.RoundView;
import lonelycoders.ufohippa.game.level.Level;
import lonelycoders.ufohippa.game.ufo.Ufo;
import lonelycoders.ufohippa.server.ServerRound;
import lonelycoders.ufohippa.server.UpdateInfo;

public class ServerGame {
    private final Map<String, Ufo> playerUfos = new HashMap<String, Ufo>();
    private ServerRound round;
    private final ServerRound.RoundListener listener;
    private final Map<AIController, Ufo> aiControllers = new HashMap<AIController, Ufo>();

    public ServerGame(ServerRound.RoundListener listener) {
        this.listener = listener;
    }

    public ServerRound initializeRound(Level level, int playingTime) {
        Collection<Ufo> ufos = this.playerUfos.values();
        this.round = new ServerRound(level, ufos, playingTime, this.listener);
        int tagIndex = (int)(Math.random() * (double)ufos.size());
        this.round.setTagUfo(ufos.toArray(new Ufo[ufos.size()])[tagIndex]);
        return this.round;
    }

    public void addUfo(Ufo ufo) {
        this.playerUfos.put(ufo.getPlayerName(), ufo);
    }

    public void start() {
        for (Map.Entry<AIController, Ufo> entry : this.aiControllers.entrySet()) {
            AIController controller = entry.getKey();
            Ufo ufo = entry.getValue();
            controller.initialize(new RoundView(this.round), ufo.getPlayerName());
        }
        for (AIController controller : this.aiControllers.keySet()) {
            controller.start();
        }
    }

    public void update(double deltaTime, UpdateInfo updateInfo) {
        this.round.update(deltaTime, updateInfo);
        for (Map.Entry<AIController, Ufo> entry : this.aiControllers.entrySet()) {
            AIController controller = entry.getKey();
            if (updateInfo.isTeleported() || updateInfo.wasTagChanged()) {
                controller.eventOccurred();
            }
            Ufo ufo = entry.getValue();
            EnumMap<Ufo.Control, Boolean> controls = new EnumMap<Ufo.Control, Boolean>(Ufo.Control.class);
            controller.getControls(new RoundView(this.round), controls);
            for (Map.Entry entry2 : controls.entrySet()) {
                ufo.setControlState((Ufo.Control)((Object)entry2.getKey()), (Boolean)entry2.getValue());
            }
        }
    }

    public Ufo getUfo(String playerName) {
        return this.playerUfos.get(playerName);
    }

    public ServerRound getRound() {
        return this.round;
    }

    public void addAI(AIController controller, Ufo ufo) {
        this.aiControllers.put(controller, ufo);
    }

    public void stop() {
        for (AIController controller : this.aiControllers.keySet()) {
            controller.stop();
        }
    }
}

