/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server;

import java.util.ArrayList;
import java.util.Collection;
import lonelycoders.ufohippa.server.ServerGame;
import lonelycoders.ufohippa.server.ServerRound;
import lonelycoders.ufohippa.server.UpdateInfo;
import lonelycoders.ufohippa.server.UpdateListener;

public class GameRunner {
    private final ServerGame serverGame;
    private final GameRunnable runner;
    private final Collection<UpdateListener> updateListeners = new ArrayList<UpdateListener>();
    private int previousFrame = 0;

    public GameRunner(ServerGame serverGame) {
        this.serverGame = serverGame;
        this.runner = new GameRunnable();
        Thread thread = new Thread((Runnable)this.runner, "Server game runner");
        thread.start();
    }

    public void start() {
        this.serverGame.start();
        this.runner.start();
    }

    public void stop() {
        this.runner.stop();
        this.serverGame.stop();
    }

    private void update(double deltaTime) {
        UpdateInfo updateInfo = new UpdateInfo();
        this.serverGame.update(deltaTime, updateInfo);
        if (this.runner.alive) {
            ServerRound round = this.serverGame.getRound();
            int currentFrame = round.getFrameCounter();
            if (this.previousFrame != currentFrame) {
                for (UpdateListener updateListener : this.updateListeners) {
                    updateListener.roundUpdated(round, updateInfo);
                }
                this.previousFrame = currentFrame;
            } else assert (updateInfo.isEmpty());
        }
    }

    public void addUpdateListener(UpdateListener listener) {
        this.updateListeners.add(listener);
    }

    private class GameRunnable
    implements Runnable {
        private final Object lock = new Object();
        private boolean alive = true;
        private boolean running = false;

        private GameRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long time = System.nanoTime();
            while (this.alive) {
                Object object = this.lock;
                synchronized (object) {
                    while (!this.running) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        time = System.nanoTime();
                    }
                }
                if (!this.alive) continue;
                long currentTime = System.nanoTime();
                long deltaTime = currentTime - time;
                time = currentTime;
                GameRunner.this.update((double)deltaTime / 1.0E9);
                try {
                    Thread.sleep(Math.max(0L, 10L - deltaTime / 1000000L));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void start() {
            this.setRunning(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.lock;
            synchronized (object) {
                this.alive = false;
                this.running = true;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRunning(boolean running) {
            Object object = this.lock;
            synchronized (object) {
                this.running = running;
                this.lock.notifyAll();
            }
        }
    }
}

