/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network.commands.match;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import lonelycoders.ufohippa.game.util.Vector2;
import lonelycoders.ufohippa.network.Command;
import lonelycoders.ufohippa.network.CommandHandler;
import lonelycoders.ufohippa.network.commands.UtilIO;

public class StartRoundCommand
extends Command {
    private static final int ID = 306;
    private final int roundNumber;
    private final String levelName;
    private final Vector2[] startingPositions;
    private final String startTag;

    public StartRoundCommand(int roundNumber, String levelName, Vector2[] startingPositions, String startTag) {
        this.roundNumber = roundNumber;
        this.levelName = levelName;
        this.startingPositions = startingPositions;
        this.startTag = startTag;
    }

    @Override
    public int getId() {
        return 306;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeInt(this.roundNumber);
        dos.writeUTF(this.levelName);
        dos.writeInt(this.startingPositions.length);
        for (Vector2 position : this.startingPositions) {
            UtilIO.writeVector2(dos, position);
        }
        dos.writeUTF(this.startTag);
    }

    public int getRoundNumber() {
        return this.roundNumber;
    }

    public Vector2[] getStartingPositions() {
        return this.startingPositions;
    }

    public String getStartTag() {
        return this.startTag;
    }

    public static abstract class Handler
    extends CommandHandler<StartRoundCommand> {
        @Override
        public int getId() {
            return 306;
        }

        @Override
        public StartRoundCommand deserialize(DataInputStream dis) throws IOException {
            int roundNumber = dis.readInt();
            String levelName = dis.readUTF();
            int playerCount = dis.readInt();
            Vector2[] startingPositions = new Vector2[playerCount];
            for (int i = 0; i < playerCount; ++i) {
                startingPositions[i] = UtilIO.readVector2(dis);
            }
            String startTag = dis.readUTF();
            return new StartRoundCommand(roundNumber, levelName, startingPositions, startTag);
        }
    }
}

