/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network.commands;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.game.util.Vector2;

public final class UtilIO {
    private UtilIO() {
    }

    public static void writeVector2(DataOutputStream dos, Vector2 vector) throws IOException {
        dos.writeFloat(vector.x);
        dos.writeFloat(vector.y);
    }

    public static Vector2 readVector2(DataInputStream dis) throws IOException {
        return new Vector2(dis.readFloat(), dis.readFloat());
    }

    public static void writeColorRGB(DataOutputStream dos, ColorRGB color) throws IOException {
        dos.writeFloat(color.getRed());
        dos.writeFloat(color.getGreen());
        dos.writeFloat(color.getBlue());
    }

    public static ColorRGB readColorRGB(DataInputStream dis) throws IOException {
        return new ColorRGB(dis.readFloat(), dis.readFloat(), dis.readFloat());
    }

    public static void writeNullableString(DataOutputStream dos, String value) throws IOException {
        if (value == null) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            dos.writeUTF(value);
        }
    }

    public static String readNullableString(DataInputStream dis) throws IOException {
        boolean nonNull = dis.readBoolean();
        if (nonNull) {
            return dis.readUTF();
        }
        return null;
    }
}

