/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network.commands;

import java.lang.reflect.Field;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.network.NetworkProtocolException;

public class CommandIDs {
    public static final int HELLO = 1;
    public static final int PLAYER_SETTINGS = 100;
    public static final int PLAYER_SETTINGS_REPLY = 101;
    public static final int CLIENT_SEND_MESSAGE = 102;
    public static final int CONTINUE = 110;
    public static final int CONTINUE_REPLY = 111;
    public static final int ALL_PLAYER_SETTINGS = 200;
    public static final int ALL_LEVEL_SETTINGS = 202;
    public static final int ALL_BASIC_SETTINGS = 204;
    public static final int SERVER_SEND_MESSAGE = 206;
    public static final int START_GAME = 210;
    public static final int START_GAME_REPLY = 211;
    public static final int MATCH_STARTING = 300;
    public static final int MATCH_STARTING_REPLY = 301;
    public static final int SEND_PLAYERS = 302;
    public static final int SEND_LEVELS = 304;
    public static final int SEND_LEVELS_REPLY = 305;
    public static final int START_ROUND = 306;
    public static final int START_ROUND_REPLY = 307;
    public static final int ROUND_END = 308;
    public static final int ROUND_END_REPLY = 309;
    public static final int ROUND_RESULTS = 310;
    public static final int MATCH_ENDED = 320;
    public static final int KEY_UPDATE = 400;
    public static final int ROUND_UPDATE = 402;
    public static final int CLIENT_DROPPED = 500;

    public static String getCommandName(int commandId) throws NetworkProtocolException {
        for (Field field : CommandIDs.class.getDeclaredFields()) {
            try {
                if (field.getInt(null) != commandId) continue;
                return field.getName();
            }
            catch (IllegalAccessException e) {
                Logger.exception(e);
            }
        }
        throw new NetworkProtocolException("Invalid command id: " + commandId);
    }
}

