/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lonelycoders.ufohippa.network.CommandHandler;
import lonelycoders.ufohippa.network.NetworkProtocolException;
import lonelycoders.ufohippa.network.State;
import lonelycoders.ufohippa.network.commands.CommandIDs;

public class CommandState
extends State {
    private final Map<Integer, CommandHandler> idCommands = new HashMap<Integer, CommandHandler>();

    public CommandState(String name, CommandHandler ... commandHandlers) {
        super(name);
        this.registerHandlers(commandHandlers);
    }

    protected void registerHandlers(CommandHandler ... commandHandlers) {
        for (CommandHandler commandHandler : commandHandlers) {
            this.registerHandler(commandHandler);
        }
    }

    @Override
    public State readCommand(DataInputStream dis) throws NetworkProtocolException {
        int commandId;
        try {
            commandId = dis.readInt();
        }
        catch (IOException e) {
            throw new NetworkProtocolException(e);
        }
        CommandHandler commandHandler = this.idCommands.get(commandId);
        if (commandHandler == null) {
            throw new NetworkProtocolException("Unexpected command in state \"" + this.name + "\": " + CommandIDs.getCommandName(commandId) + "(" + commandId + ")");
        }
        return commandHandler.process(dis);
    }

    private void registerHandler(CommandHandler commandHandler) {
        this.idCommands.put(commandHandler.getId(), commandHandler);
    }
}

