/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.leveleditor;

import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.client.sound.EmptySoundManager;
import lonelycoders.ufohippa.client.states.match.ClientRound;
import lonelycoders.ufohippa.game.level.Level;
import lonelycoders.ufohippa.game.level.LevelDescriptor;
import lonelycoders.ufohippa.game.level.Teleport;
import lonelycoders.ufohippa.game.level.Tile;
import lonelycoders.ufohippa.game.level.TileSet;
import lonelycoders.ufohippa.game.ufo.Ufo;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.leveleditor.gl.OpenGLLevelEditorRenderer;
import lonelycoders.ufohippa.util.XmlException;

public class LevelEditor {
    private final OpenGLLevelEditorRenderer renderer;
    private Level level;
    private File levelPath;
    private Tool tool;
    private Tile primaryTile;
    private Tile secondaryTile;
    private ColorRGB tileColor;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public LevelEditor() {
        Object lock = new Object();
        ResourceManager resourceManager = new ResourceManager();
        this.renderer = new OpenGLLevelEditorRenderer(lock, resourceManager);
        this.renderer.setInputHandler(new InputHandler());
    }

    public void newLevel(String author, String tileSetName) {
        try {
            Level level = new Level(null, author, new TileSet(tileSetName));
            this.setLevel(level);
            this.levelPath = null;
        }
        catch (XmlException e) {
            Logger.exception(e);
        }
    }

    public void setLevel(File levelPath, LevelDescriptor levelDescriptor) {
        this.levelPath = levelPath;
        this.setLevel(levelDescriptor.load());
    }

    private void setLevel(Level level) {
        this.level = level;
        ArrayList<Ufo> ufos = new ArrayList<Ufo>();
        ClientRound round = new ClientRound(new EmptySoundManager(), level, ufos, 10);
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.tileSetChanged(level.getTileSet().getName());
        }
        this.renderer.loadTileSet(level.getTileSet());
        this.renderer.initialize(round);
    }

    public void saveLevel(File levelPath) {
        LevelDescriptor.save(this.level, levelPath);
        this.levelPath = levelPath;
    }

    public File getLevelPath() {
        return this.levelPath;
    }

    public JComponent getComponent() {
        return this.renderer.getComponent();
    }

    public void setTool(Tool tool) {
        this.tool = tool;
        this.renderer.setTool(tool);
    }

    public void setPrimaryTile(Tile tile) {
        this.primaryTile = tile;
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.tileChanged(tile, true);
        }
    }

    public Tile getPrimaryTile() {
        return this.primaryTile;
    }

    public void setSecondaryTile(Tile tile) {
        this.secondaryTile = tile;
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.tileChanged(tile, false);
        }
    }

    public Tile getSecondaryTile() {
        return this.secondaryTile;
    }

    public void setTileColor(ColorRGB tileColor) {
        this.tileColor = tileColor;
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.tileColorChanged(tileColor);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void setActive(boolean active) {
        this.renderer.setActive(active);
    }

    public static interface ChangeListener {
        public void tileChanged(Tile var1, boolean var2);

        public void tileSetChanged(String var1);

        public void tileColorChanged(ColorRGB var1);
    }

    private class InputHandler
    implements OpenGLLevelEditorRenderer.InputHandler {
        private InputHandler() {
        }

        @Override
        public void mousePressed(int tileX, int tileY, boolean leftButton, MouseEvent mouseEvent) {
            if (LevelEditor.this.level != null) {
                switch (LevelEditor.this.tool) {
                    case DRAW: {
                        Tile tile;
                        if (mouseEvent.isControlDown()) {
                            Tile tile2 = LevelEditor.this.level.getTiles().getTile(tileX, tileY);
                            if (leftButton) {
                                LevelEditor.this.setPrimaryTile(tile2);
                                break;
                            }
                            LevelEditor.this.setSecondaryTile(tile2);
                            break;
                        }
                        if (mouseEvent.isAltDown()) {
                            ColorRGB color = LevelEditor.this.level.getTiles().getColor(tileX, tileY);
                            LevelEditor.this.setTileColor(color);
                            break;
                        }
                        Tile tile3 = tile = leftButton ? LevelEditor.this.primaryTile : LevelEditor.this.secondaryTile;
                        if (tile == null) break;
                        if (LevelEditor.this.tileColor != null && tile.supportsColoring()) {
                            LevelEditor.this.level.getTiles().setTile(tileX, tileY, tile, LevelEditor.this.tileColor);
                            break;
                        }
                        LevelEditor.this.level.getTiles().setTile(tileX, tileY, tile);
                        break;
                    }
                    case TELEPORT_NORMAL: 
                    case TELEPORT_ANYWHERE: {
                        Teleport.Type type;
                        boolean removed = false;
                        Iterator<Teleport> it = LevelEditor.this.level.getTeleports().iterator();
                        while (it.hasNext()) {
                            Teleport teleport = it.next();
                            if (teleport.getX() != tileX || teleport.getY() != tileY) continue;
                            it.remove();
                            removed = true;
                        }
                        if (removed) break;
                        if (LevelEditor.this.tool == Tool.TELEPORT_NORMAL) {
                            type = Teleport.Type.NORMAL;
                        } else if (LevelEditor.this.tool == Tool.TELEPORT_ANYWHERE) {
                            type = Teleport.Type.ANYWHERE;
                        } else {
                            throw new IllegalStateException();
                        }
                        LevelEditor.this.level.getTeleports().add(new Teleport(type, tileX, tileY));
                        break;
                    }
                    case ADD_COLUMN: {
                        LevelEditor.this.level.insertColumn(tileX);
                        break;
                    }
                    case REMOVE_COLUMN: {
                        LevelEditor.this.level.removeColumn(tileX);
                        break;
                    }
                    case ADD_ROW: {
                        LevelEditor.this.level.insertRow(tileY);
                        break;
                    }
                    case REMOVE_ROW: {
                        LevelEditor.this.level.removeRow(tileY);
                    }
                }
            }
        }

        @Override
        public void mouseReleased(int tileX, int tileY, boolean leftButton) {
        }

        @Override
        public void mouseDragged(int tileX, int tileY, boolean leftButton, MouseEvent mouseEvent) {
            if (LevelEditor.this.level != null) {
                switch (LevelEditor.this.tool) {
                    case DRAW: {
                        Tile tile;
                        Tile tile2 = tile = leftButton ? LevelEditor.this.primaryTile : LevelEditor.this.secondaryTile;
                        if (tile == null) break;
                        if (LevelEditor.this.tileColor != null && tile.supportsColoring()) {
                            LevelEditor.this.level.getTiles().setTile(tileX, tileY, tile, LevelEditor.this.tileColor);
                            break;
                        }
                        LevelEditor.this.level.getTiles().setTile(tileX, tileY, tile);
                    }
                }
            }
        }
    }

    public static enum Tool {
        DRAW,
        FLOOD_FILL,
        TELEPORT_NORMAL,
        TELEPORT_ANYWHERE,
        ADD_COLUMN,
        REMOVE_COLUMN,
        ADD_ROW,
        REMOVE_ROW;

    }
}

