/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.general;

import lonelycoders.ufohippa.general.Logger;

public class StoppableThread {
    private final Object lock = new Object();
    private final Thread thread;
    private boolean alive = true;
    private boolean running = false;

    public StoppableThread(String name, final Runnable runnable) {
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (StoppableThread.this.alive) {
                    Object object = StoppableThread.this.lock;
                    synchronized (object) {
                        while (!StoppableThread.this.running) {
                            try {
                                StoppableThread.this.lock.wait();
                            }
                            catch (InterruptedException e) {
                                Logger.exception(e);
                            }
                        }
                    }
                    if (!StoppableThread.this.alive) continue;
                    runnable.run();
                }
            }
        }, name);
        this.thread.start();
    }

    public void start() {
        this.setRunning(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.interrupt();
            this.alive = false;
            this.running = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(boolean running) {
        Object object = this.lock;
        synchronized (object) {
            this.running = running;
            this.lock.notifyAll();
        }
    }

    public void interrupt() {
        this.thread.interrupt();
    }

    public boolean isAlive() {
        return this.alive;
    }
}

