/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.util;

import java.nio.DoubleBuffer;

public class Vector3 {
    public float x;
    public float y;
    public float z;

    public Vector3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(float x, float y, float z, boolean normalize) {
        this(x, y, z);
        if (normalize) {
            this.normalize();
        }
    }

    public Vector3(Vector3 other) {
        this(other.x, other.y, other.z);
    }

    public Vector3(DoubleBuffer buffer) {
        this((float)buffer.get(0), (float)buffer.get(1), (float)buffer.get(2));
    }

    public void add(Vector3 position) {
        this.x += position.x;
        this.y += position.y;
        this.z += position.z;
    }

    public void sub(Vector3 other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
    }

    public void multiply(Vector3 other) {
        this.x *= other.x;
        this.y *= other.y;
        this.z *= other.z;
    }

    public void divide(Vector3 other) {
        this.x /= other.x;
        this.y /= other.y;
        this.z /= other.z;
    }

    public void scale(float scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
    }

    public void addScaled(Vector3 other, float scale) {
        this.x += other.x * scale;
        this.y += other.y * scale;
        this.z += other.z * scale;
    }

    public void blend(Vector3 other, float factor) {
        this.x = this.x * (1.0f - factor) + other.x * factor;
        this.y = this.y * (1.0f - factor) + other.y * factor;
        this.z = this.z * (1.0f - factor) + other.z * factor;
    }

    public float dot(Vector3 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public float getLength() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float getLength2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void normalize() {
        float length = this.getLength();
        this.x /= length;
        this.y /= length;
        this.z /= length;
    }

    public void inverse() {
        this.x = 1.0f / this.x;
        this.y = 1.0f / this.y;
        this.z = 1.0f / this.z;
    }

    public void reflect(Vector3 normal, float factor) {
        float dot = this.dot(normal);
        if (dot < 0.0f) {
            this.x -= (1.0f + factor) * normal.x * dot;
            this.y -= (1.0f + factor) * normal.y * dot;
            this.z -= (1.0f + factor) * normal.z * dot;
        }
    }

    public float[] toFloatArray() {
        return new float[]{this.x, this.y, this.z};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector3 vector3 = (Vector3)o;
        return Float.compare(vector3.x, this.x) == 0 && Float.compare(vector3.y, this.y) == 0 && Float.compare(vector3.z, this.z) == 0;
    }

    public int hashCode() {
        int result = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
        result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
        result = 31 * result + (this.z != 0.0f ? Float.floatToIntBits(this.z) : 0);
        return result;
    }

    public String toString() {
        return "Vector3{" + this.x + ", " + this.y + ", " + this.z + '}';
    }
}

