/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.level;

import java.util.Iterator;
import lonelycoders.ufohippa.game.level.Tile;
import lonelycoders.ufohippa.game.util.ColorRGB;

public class TileMap {
    private int width;
    private int height;
    private Tile[][] tiles;
    private ColorRGB[][] colors;

    public TileMap(int width, int height) {
        this.width = width;
        this.height = height;
        this.tiles = new Tile[height][width];
        this.colors = new ColorRGB[height][width];
    }

    public void setTile(int x, int y, Tile tile) {
        this.setTile(x, y, tile, null);
    }

    public void setTile(int x, int y, Tile tile, ColorRGB color) {
        this.tiles[y][x] = tile;
        this.colors[y][x] = color;
    }

    public void setColor(int x, int y, ColorRGB color) {
        this.colors[y][x] = color;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Tile getTile(int x, int y) {
        return this.tiles[Math.max(0, Math.min(this.height - 1, y))][Math.max(0, Math.min(this.width - 1, x))];
    }

    public ColorRGB getColor(int x, int y) {
        return this.colors[Math.max(0, Math.min(this.height - 1, y))][Math.max(0, Math.min(this.width - 1, x))];
    }

    public Iterable<TileIteration> getAllTiles() {
        return new Iterable<TileIteration>(){

            @Override
            public Iterator<TileIteration> iterator() {
                return new TileIterator();
            }
        };
    }

    public boolean isPassable(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height && this.tiles[y][x].getCollision() == Tile.Collision.NONE;
    }

    private void copyArea(Tile[][] sourceTiles, ColorRGB[][] sourceColors, Tile[][] targetTiles, ColorRGB[][] targetColors, int sourceX, int sourceY, int targetX, int targetY, int width, int height) {
        for (int y = 0; y < height; ++y) {
            System.arraycopy(sourceTiles[sourceY + y], sourceX, targetTiles[targetY + y], targetX, width);
            System.arraycopy(sourceColors[sourceY + y], sourceX, targetColors[targetY + y], targetX, width);
        }
    }

    public void insertColumn(int column) {
        Tile[][] newTiles = new Tile[this.height][this.width + 1];
        ColorRGB[][] newColors = new ColorRGB[this.height][this.width + 1];
        this.copyArea(this.tiles, this.colors, newTiles, newColors, 0, 0, 0, 0, column, this.height);
        this.copyArea(this.tiles, this.colors, newTiles, newColors, column, 0, column, 0, 1, this.height);
        this.copyArea(this.tiles, this.colors, newTiles, newColors, column, 0, column + 1, 0, this.width - column, this.height);
        ++this.width;
        this.tiles = newTiles;
        this.colors = newColors;
    }

    public void removeColumn(int column) {
        Tile[][] newTiles = new Tile[this.height][this.width - 1];
        ColorRGB[][] newColors = new ColorRGB[this.height][this.width - 1];
        this.copyArea(this.tiles, this.colors, newTiles, newColors, 0, 0, 0, 0, column, this.height);
        this.copyArea(this.tiles, this.colors, newTiles, newColors, column + 1, 0, column, 0, this.width - column - 1, this.height);
        --this.width;
        this.tiles = newTiles;
        this.colors = newColors;
    }

    public void insertRow(int row) {
        Tile[][] newTiles = new Tile[this.height + 1][this.width];
        ColorRGB[][] newColors = new ColorRGB[this.height + 1][this.width];
        this.copyArea(this.tiles, this.colors, newTiles, newColors, 0, 0, 0, 0, this.width, row);
        this.copyArea(this.tiles, this.colors, newTiles, newColors, 0, row, 0, row, this.width, 1);
        this.copyArea(this.tiles, this.colors, newTiles, newColors, 0, row, 0, row + 1, this.width, this.height - row);
        ++this.height;
        this.tiles = newTiles;
        this.colors = newColors;
    }

    public void removeRow(int row) {
        Tile[][] newTiles = new Tile[this.height - 1][this.width];
        ColorRGB[][] newColors = new ColorRGB[this.height - 1][this.width];
        this.copyArea(this.tiles, this.colors, newTiles, newColors, 0, 0, 0, 0, this.width, row);
        this.copyArea(this.tiles, this.colors, newTiles, newColors, 0, row + 1, 0, row, this.width, this.height - row - 1);
        --this.height;
        this.tiles = newTiles;
        this.colors = newColors;
    }

    public static class TileIteration {
        public final int x;
        public final int y;
        public final Tile tile;
        public ColorRGB color;

        public TileIteration(int x, int y, Tile tile, ColorRGB color) {
            this.x = x;
            this.y = y;
            this.tile = tile;
            this.color = color;
        }
    }

    private class TileIterator
    implements Iterator<TileIteration> {
        private int x = 0;
        private int y = 0;

        private TileIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.x < TileMap.this.width && this.y < TileMap.this.height;
        }

        @Override
        public TileIteration next() {
            TileIteration tileIteration = new TileIteration(this.x, this.y, TileMap.this.tiles[this.y][this.x], TileMap.this.colors[this.y][this.x]);
            ++this.x;
            if (this.x == TileMap.this.width) {
                this.x = 0;
                ++this.y;
            }
            return tileIteration;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

