/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.level;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lonelycoders.ufohippa.game.level.Teleport;
import lonelycoders.ufohippa.game.level.TileMap;
import lonelycoders.ufohippa.game.util.Vector2;

public final class LevelUtil {
    private LevelUtil() {
    }

    public static Set<TilePosition> findAvailablePositions(TileMap tiles, List<Teleport> teleports) {
        TilePosition firstPosition;
        HashSet<TilePosition> allAvailableTiles = new HashSet<TilePosition>();
        HashSet<TilePosition> teleportPositions = new HashSet<TilePosition>();
        for (Teleport teleport : teleports) {
            if (teleport.getType() != Teleport.Type.NORMAL) continue;
            teleportPositions.add(new TilePosition(teleport.getX(), teleport.getY()));
        }
        ArrayList<Set<TilePosition>> connectedGroups = new ArrayList<Set<TilePosition>>();
        do {
            if ((firstPosition = LevelUtil.findFirstAvailablePosition(tiles, allAvailableTiles)) == null) continue;
            Set<TilePosition> connectedTiles = LevelUtil.findConnectedAvailablePositions(tiles, teleportPositions, firstPosition);
            connectedGroups.add(connectedTiles);
            allAvailableTiles.addAll(connectedTiles);
        } while (firstPosition != null);
        return Collections.max(connectedGroups, new Comparator<Set<TilePosition>>(){

            @Override
            public int compare(Set<TilePosition> o1, Set<TilePosition> o2) {
                return o1.size() - o2.size();
            }
        });
    }

    private static Set<TilePosition> findConnectedAvailablePositions(TileMap tiles, Set<TilePosition> teleportPositions, TilePosition startPosition) {
        HashSet<TilePosition> connectedPositions = new HashSet<TilePosition>();
        LevelUtil.findConnectedAvailablePositionsRecursive(tiles, teleportPositions, connectedPositions, startPosition.x, startPosition.y);
        return connectedPositions;
    }

    private static void findConnectedAvailablePositionsRecursive(TileMap tiles, Set<TilePosition> teleportPositions, Set<TilePosition> connectedPositions, int x, int y) {
        TilePosition position = new TilePosition(x, y);
        if (!connectedPositions.contains(position) && LevelUtil.isAvailablePosition(tiles, x, y)) {
            connectedPositions.add(position);
            LevelUtil.findConnectedAvailablePositionsRecursive(tiles, teleportPositions, connectedPositions, x, y - 1);
            LevelUtil.findConnectedAvailablePositionsRecursive(tiles, teleportPositions, connectedPositions, x - 1, y);
            LevelUtil.findConnectedAvailablePositionsRecursive(tiles, teleportPositions, connectedPositions, x + 1, y);
            LevelUtil.findConnectedAvailablePositionsRecursive(tiles, teleportPositions, connectedPositions, x, y + 1);
            if (teleportPositions.contains(position)) {
                for (TilePosition teleportPosition : teleportPositions) {
                    LevelUtil.findConnectedAvailablePositionsRecursive(tiles, Collections.<TilePosition>emptySet(), connectedPositions, teleportPosition.getX(), teleportPosition.getY());
                }
            }
        }
    }

    private static TilePosition findFirstAvailablePosition(TileMap tiles, Set<TilePosition> disallowedTiles) {
        for (TileMap.TileIteration tileIteration : tiles.getAllTiles()) {
            if (disallowedTiles.contains(new TilePosition(tileIteration.x, tileIteration.y)) || !LevelUtil.isAvailableStartingPosition(tiles, tileIteration.x, tileIteration.y)) continue;
            return new TilePosition(tileIteration.x, tileIteration.y);
        }
        return null;
    }

    public static boolean isAvailablePosition(TileMap tiles, int tileX, int tileY) {
        return tiles.isPassable(tileX, tileY) && tiles.isPassable(tileX + 1, tileY);
    }

    private static boolean isAvailableStartingPosition(TileMap tiles, int tileX, int tileY) {
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 2; ++x) {
                if (tiles.isPassable(tileX + x, tileY + y)) continue;
                return false;
            }
        }
        return true;
    }

    public static Vector2[] getStartingPositions(TileMap tiles, Set<TilePosition> availablePositions) {
        Set<TilePosition> availableStartingPositions = LevelUtil.getAvailableStartingPositions(tiles, availablePositions);
        boolean[][] availablePositionsArray = LevelUtil.transformPositions(tiles, availablePositions);
        boolean[][] availableStartingPositionsArray = LevelUtil.transformPositions(tiles, availableStartingPositions);
        List<TilePosition> optimalStartingPositions = LevelUtil.getOptimalStartingPositions(tiles, availablePositions, availablePositionsArray, availableStartingPositions, availableStartingPositionsArray, 16);
        Vector2[] startingPositions = new Vector2[optimalStartingPositions.size()];
        int i = 0;
        for (TilePosition position : optimalStartingPositions) {
            startingPositions[i++] = new Vector2((float)position.x + 1.0f, (float)position.y + 0.5f);
        }
        return startingPositions;
    }

    private static List<TilePosition> getOptimalStartingPositions(TileMap tiles, Set<TilePosition> availablePositions, boolean[][] availablePositionsArray, Set<TilePosition> availableStartingPositions, boolean[][] availableStartingPositionsArray, int number) {
        float weightX = 0.5f;
        float weightY = 0.0f;
        for (TilePosition position : availableStartingPositions) {
            weightX += (float)position.x;
            weightY += (float)position.y;
        }
        ArrayList<TilePosition> positions = new ArrayList<TilePosition>();
        TilePosition firstPosition = LevelUtil.findFarthestPosition(availableStartingPositions, weightX /= (float)availableStartingPositions.size(), weightY /= (float)availableStartingPositions.size());
        positions.add(firstPosition);
        for (int i = 0; i < number - 1; ++i) {
            positions.add(LevelUtil.findFarthestPosition(availableStartingPositions, positions));
        }
        return positions;
    }

    private static TilePosition findFarthestPosition(Set<TilePosition> positions, final float x, final float y) {
        return Collections.max(positions, new Comparator<TilePosition>(){

            @Override
            public int compare(TilePosition o1, TilePosition o2) {
                int result = (int)(((float)o1.x - x) * ((float)o1.x - x) + ((float)o1.y - y) * ((float)o1.y - y) - (((float)o2.x - x) * ((float)o2.x - x) + ((float)o2.y - y) * ((float)o2.y - y)));
                return result;
            }
        });
    }

    private static TilePosition findFarthestPosition(Set<TilePosition> positions, final Collection<TilePosition> others) {
        return Collections.max(positions, new Comparator<TilePosition>(){

            @Override
            public int compare(TilePosition o1, TilePosition o2) {
                int minDistance1 = Integer.MAX_VALUE;
                int minDistance2 = Integer.MAX_VALUE;
                for (TilePosition other : others) {
                    int distance1 = (o1.x - other.x) * (o1.x - other.x) + (o1.y - other.y) * (o1.y - other.y);
                    int distance2 = (o2.x - other.x) * (o2.x - other.x) + (o2.y - other.y) * (o2.y - other.y);
                    minDistance1 = Math.min(minDistance1, distance1);
                    minDistance2 = Math.min(minDistance2, distance2);
                }
                return minDistance1 - minDistance2;
            }
        });
    }

    private static Set<TilePosition> getAvailableStartingPositions(TileMap tiles, Set<TilePosition> availablePositions) {
        HashSet<TilePosition> positions = new HashSet<TilePosition>();
        for (TilePosition availablePosition : availablePositions) {
            if (!LevelUtil.isAvailableStartingPosition(tiles, availablePosition.x, availablePosition.y)) continue;
            positions.add(availablePosition);
        }
        return positions;
    }

    private static boolean[][] transformPositions(TileMap tiles, Set<TilePosition> availablePositions) {
        boolean[][] positions = new boolean[tiles.getHeight()][tiles.getWidth()];
        for (int y = 0; y < tiles.getHeight(); ++y) {
            for (int x = 0; x < tiles.getWidth(); ++x) {
                positions[y][x] = availablePositions.contains(new TilePosition(x, y));
            }
        }
        return positions;
    }

    public static class TilePosition {
        private final int x;
        private final int y;

        public TilePosition(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TilePosition that = (TilePosition)o;
            return this.x == that.x && this.y == that.y;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.y;
            return result;
        }

        public String toString() {
            return "TilePosition{x=" + this.x + ", y=" + this.y + '}';
        }
    }
}

