/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.level;

import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import lonelycoders.ufohippa.game.level.Level;
import lonelycoders.ufohippa.game.level.Teleport;
import lonelycoders.ufohippa.game.level.TileMap;
import lonelycoders.ufohippa.game.level.TileSet;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.util.XmlException;
import lonelycoders.ufohippa.util.XmlUtil;
import org.w3c.dom.Element;

public class LevelDescriptor
implements Comparable<LevelDescriptor> {
    private final String folderName;
    private final String name;
    private final File path;

    public LevelDescriptor(String folderName, String name, File path) {
        this.folderName = folderName;
        this.name = name;
        this.path = path;
    }

    public Level load() {
        try {
            Element elementLevel = XmlUtil.parseXml(this.path);
            String author = XmlUtil.getStringAttribute(elementLevel, "author");
            int width = XmlUtil.getIntAttribute(elementLevel, "width");
            int height = XmlUtil.getIntAttribute(elementLevel, "height");
            Element elementTileSet = XmlUtil.getChildElement(elementLevel, "tileset");
            String tileSetName = XmlUtil.getStringAttribute(elementTileSet, "name");
            TileSet tileSet = new TileSet(tileSetName);
            TileMap tiles = new TileMap(width, height);
            Element elementTiles = XmlUtil.getChildElement(elementLevel, "tiles");
            String stringTiles = XmlUtil.getElementText(elementTiles);
            StringTokenizer st = new StringTokenizer(stringTiles, ",", false);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int tileId;
                    String tileIdString = "";
                    try {
                        tileIdString = st.nextToken().trim();
                        tileId = Integer.parseInt(tileIdString);
                    }
                    catch (NoSuchElementException e) {
                        throw new XmlException("Invalid tile data");
                    }
                    catch (NumberFormatException e) {
                        throw new XmlException("Invalid tile id: " + tileIdString);
                    }
                    tiles.setTile(x, height - 1 - y, tileSet.getTile(tileId));
                }
            }
            if (XmlUtil.hasChild(elementLevel, "tileColors")) {
                Element elementTileColors = XmlUtil.getChildElement(elementLevel, "tileColors");
                String stringTileColors = XmlUtil.getElementText(elementTileColors);
                st = new StringTokenizer(stringTileColors, ",", false);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        String tileColorString = "";
                        try {
                            tileColorString = st.nextToken().trim();
                            if (tileColorString.isEmpty()) continue;
                            ColorRGB color = ColorRGB.fromString(tileColorString);
                            tiles.setColor(x, height - 1 - y, color);
                            continue;
                        }
                        catch (NoSuchElementException e) {
                            throw new XmlException("Invalid tile data");
                        }
                        catch (NumberFormatException e) {
                            throw new XmlException("Invalid tile id: " + tileColorString);
                        }
                    }
                }
            }
            Level level = new Level(this, author, tiles, tileSet);
            level.fixBorders();
            Element elementObjects = XmlUtil.getChildElement(elementLevel, "objects");
            for (Element elementTeleport : XmlUtil.getChildElements(elementObjects, "teleport")) {
                Teleport.Type type;
                String typeString = XmlUtil.getStringAttribute(elementTeleport, "type");
                if (typeString.equals("normal")) {
                    type = Teleport.Type.NORMAL;
                } else if (typeString.equals("anywhere")) {
                    type = Teleport.Type.ANYWHERE;
                } else {
                    throw new XmlException("Invalid teleport type");
                }
                int x = XmlUtil.getIntAttribute(elementTeleport, "x");
                int y = XmlUtil.getIntAttribute(elementTeleport, "y");
                Teleport teleport = new Teleport(type, x, y);
                level.getTeleports().add(teleport);
            }
            level.initializeStartingPositions();
            return level;
        }
        catch (IOException e) {
            Logger.exception(e);
        }
        catch (XmlException e) {
            Logger.exception(e);
        }
        return null;
    }

    public static void save(Level level, File levelPath) {
        try {
            Element elementLevel = XmlUtil.createXml("level");
            XmlUtil.setAttribute(elementLevel, "author", level.getAuthor());
            XmlUtil.setAttribute(elementLevel, "width", level.getWidth());
            XmlUtil.setAttribute(elementLevel, "height", level.getHeight());
            TileSet tileSet = level.getTileSet();
            Element elementTileSet = XmlUtil.createChildElement(elementLevel, "tileset");
            XmlUtil.setAttribute(elementTileSet, "name", tileSet.getName());
            TileMap tiles = level.getTiles();
            Element elementTiles = XmlUtil.createChildElement(elementLevel, "tiles");
            StringBuilder sb = new StringBuilder("\n");
            for (int y = 0; y < tiles.getHeight(); ++y) {
                sb.append("        ");
                for (int x = 0; x < tiles.getWidth(); ++x) {
                    sb.append(tiles.getTile(x, tiles.getHeight() - 1 - y).getId());
                    sb.append(", ");
                }
                sb.append('\n');
            }
            sb.append("    ");
            XmlUtil.setElementText(elementTiles, sb.toString());
            boolean hasColors = false;
            for (TileMap.TileIteration tile : tiles.getAllTiles()) {
                hasColors |= tile.color != null;
            }
            if (hasColors) {
                Element elementTileColors = XmlUtil.createChildElement(elementLevel, "tileColors");
                sb = new StringBuilder("\n");
                for (int y = 0; y < tiles.getHeight(); ++y) {
                    sb.append("        ");
                    for (int x = 0; x < tiles.getWidth(); ++x) {
                        ColorRGB color = tiles.getColor(x, tiles.getHeight() - 1 - y);
                        if (color != null) {
                            sb.append(color.asString(';'));
                        }
                        sb.append(", ");
                    }
                    sb.append('\n');
                }
                sb.append("    ");
                XmlUtil.setElementText(elementTileColors, sb.toString());
            }
            Element elementObjects = XmlUtil.createChildElement(elementLevel, "objects");
            for (Teleport teleport : level.getTeleports()) {
                Element elementTeleport = XmlUtil.createChildElement(elementObjects, "teleport");
                elementObjects.appendChild(elementTeleport);
                elementTeleport.setAttribute("x", "" + teleport.getX());
                elementTeleport.setAttribute("y", "" + teleport.getY());
                String type = "";
                switch (teleport.getType()) {
                    case NORMAL: {
                        type = "normal";
                        break;
                    }
                    case ANYWHERE: {
                        type = "anywhere";
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                XmlUtil.setAttribute(elementTeleport, "type", type);
            }
            XmlUtil.saveXml(elementLevel, levelPath);
        }
        catch (XmlException e) {
            Logger.exception(e);
        }
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(LevelDescriptor other) {
        return this.getName().compareTo(other.getName());
    }

    public static enum LevelType {
        BUILT_IN,
        RECEIVED,
        CREATED,
        UNKNOWN;

    }
}

