/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.ai.pathfindingai;

import lonelycoders.ufohippa.game.level.LevelUtil;

public class RouteNode
implements Comparable<RouteNode> {
    private final RouteNode previousNode;
    private final LevelUtil.TilePosition position;
    private final float currentCost;
    private final boolean discontinuous;
    private final float estimate;

    public RouteNode(RouteNode previousNode, LevelUtil.TilePosition position, float currentCost, float estimateLeft, boolean discontinuous) {
        this.previousNode = previousNode;
        this.position = position;
        this.currentCost = currentCost;
        this.discontinuous = discontinuous;
        this.estimate = currentCost + estimateLeft;
    }

    public RouteNode getPreviousNode() {
        return this.previousNode;
    }

    public LevelUtil.TilePosition getPosition() {
        return this.position;
    }

    public float getCurrentCost() {
        return this.currentCost;
    }

    public boolean isDiscontinuous() {
        return this.discontinuous;
    }

    @Override
    public int compareTo(RouteNode o) {
        if (this.estimate < o.estimate) {
            return -1;
        }
        if (this.estimate > o.estimate) {
            return 1;
        }
        return 0;
    }
}

