/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.ai.pathfindingai;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import lonelycoders.ufohippa.game.ai.AIController;
import lonelycoders.ufohippa.game.ai.RoundView;
import lonelycoders.ufohippa.game.ai.pathfindingai.EscapeEstimator;
import lonelycoders.ufohippa.game.ai.pathfindingai.LevelAStar;
import lonelycoders.ufohippa.game.ai.pathfindingai.MultiTargetEstimator;
import lonelycoders.ufohippa.game.ai.pathfindingai.Route;
import lonelycoders.ufohippa.game.ai.pathfindingai.RouteNode;
import lonelycoders.ufohippa.game.level.LevelUtil;
import lonelycoders.ufohippa.game.ufo.Ufo;
import lonelycoders.ufohippa.game.util.Vector2;

public class PathFindingAI
implements AIController {
    private static final int ROUTING_DELAY = 500;
    private static final float SHOOT_PROBABILITY = 0.05f;
    private final Timer timer = new Timer();
    private TimerTask task;
    private boolean shouldUpdate;
    private String playerName;
    private Route route;
    private LevelAStar aStar;

    @Override
    public String getName() {
        return "Good";
    }

    @Override
    public void initialize(RoundView round, String playerName) {
        this.playerName = playerName;
        this.aStar = new LevelAStar(round.getLevel());
    }

    @Override
    public void start() {
        this.task = new TimerTask(){

            @Override
            public void run() {
                PathFindingAI.this.shouldUpdate = true;
            }
        };
        this.timer.schedule(this.task, 0L, 500L);
    }

    @Override
    public void eventOccurred() {
        this.aStar.randomizeTeleports(false);
        this.route = null;
    }

    @Override
    public void getControls(RoundView round, Map<Ufo.Control, Boolean> controls) {
        if (this.route == null) {
            this.shouldUpdate = true;
        }
        Ufo myUfo = round.findUfo(this.playerName);
        Vector2 myPosition = myUfo.getPosition();
        if (this.shouldUpdate) {
            Ufo tagUfo = round.getTagUfo();
            if (tagUfo != myUfo) {
                Vector2 tagPosition = tagUfo.getPosition();
                this.route = this.aStar.findRoute(PathFindingAI.getTilePosition(myPosition), new EscapeEstimator(round.getLevel(), PathFindingAI.getTilePosition(tagPosition)), true);
            } else {
                ArrayList<LevelUtil.TilePosition> opponentPositions = new ArrayList<LevelUtil.TilePosition>();
                for (Ufo ufo : round.getAllUfos()) {
                    if (ufo == myUfo || ufo.isAIPlayer()) continue;
                    opponentPositions.add(PathFindingAI.getTilePosition(ufo.getPosition()));
                }
                this.route = this.aStar.findRoute(PathFindingAI.getTilePosition(myPosition), new MultiTargetEstimator(round.getLevel(), opponentPositions), false);
            }
            this.shouldUpdate = false;
        }
        if (this.route != null) {
            Iterator<RouteNode> it = this.route.getNodes().iterator();
            while (it.hasNext()) {
                RouteNode node = it.next();
                LevelUtil.TilePosition targetPosition = node.getPosition();
                Vector2 direction = PathFindingAI.getVectorPosition(targetPosition);
                direction.sub(myPosition);
                if (direction.getLength2() < 1.0f) {
                    it.remove();
                    continue;
                }
                for (int i = 0; i < 3 && it.hasNext() && !(node = it.next()).isDiscontinuous(); ++i) {
                    targetPosition = node.getPosition();
                    Vector2 direction2 = PathFindingAI.getVectorPosition(targetPosition);
                    direction2.sub(myPosition);
                    direction.addScaled(direction2, 1.0f / (float)(i + 2));
                }
                PathFindingAI.seek(controls, direction);
                break;
            }
            if (!it.hasNext()) {
                this.route = null;
            }
        }
        controls.put(Ufo.Control.FIRE, Math.random() < (double)0.05f);
    }

    private static LevelUtil.TilePosition getTilePosition(Vector2 position) {
        return new LevelUtil.TilePosition((int)(position.x - 0.5f), (int)position.y);
    }

    private static Vector2 getVectorPosition(LevelUtil.TilePosition position) {
        return new Vector2((float)position.getX() + 0.5f, (float)position.getY() + 0.5f);
    }

    private static void seek(Map<Ufo.Control, Boolean> controls, Vector2 direction) {
        float ratio = Math.abs(direction.x / direction.y);
        if ((double)ratio > 0.1) {
            controls.put(Ufo.Control.LEFT, direction.x < 0.0f);
            controls.put(Ufo.Control.RIGHT, direction.x > 0.0f);
        }
        if ((double)(1.0f / ratio) > 0.1) {
            controls.put(Ufo.Control.DOWN, direction.y < 0.0f);
            controls.put(Ufo.Control.UP, direction.y > 0.0f);
        }
    }

    @Override
    public void stop() {
        this.task.cancel();
    }
}

