/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class RoundResults {
    private final Map<String, Integer> oldPlayerPoints;
    private final Map<String, Double> playerTagTimes;
    private final Map<String, Integer> addedPlayerPoints;
    private final List<String[]> currentRoundPlayersOrder;
    private final List<String[]> allRoundsOldPlayersOrder;
    private final List<String[]> allRoundsNewPlayersOrder;

    public RoundResults(Map<String, Double> playerTagTimes, Map<String, Integer> oldPlayerPoints, Map<String, Integer> addedPlayerPoints) {
        this.playerTagTimes = playerTagTimes;
        this.oldPlayerPoints = oldPlayerPoints;
        this.addedPlayerPoints = addedPlayerPoints;
        this.currentRoundPlayersOrder = this.createOrder(addedPlayerPoints);
        this.allRoundsOldPlayersOrder = this.createOrder(oldPlayerPoints);
        HashMap<String, Integer> newAllRoundsPlayerPoints = new HashMap<String, Integer>();
        for (String playerName : oldPlayerPoints.keySet()) {
            newAllRoundsPlayerPoints.put(playerName, oldPlayerPoints.get(playerName) + addedPlayerPoints.get(playerName));
        }
        this.allRoundsNewPlayersOrder = this.createOrder(newAllRoundsPlayerPoints);
    }

    private List<String[]> createOrder(Map<String, Integer> newPlayerPoints) {
        TreeMap roundOrder = new TreeMap();
        for (Map.Entry<String, Integer> entry : newPlayerPoints.entrySet()) {
            String playerName = entry.getKey();
            int points = entry.getValue();
            if (!roundOrder.containsKey(points)) {
                roundOrder.put(points, new ArrayList());
            }
            List players = (List)roundOrder.get(points);
            players.add(playerName);
        }
        ArrayList<String[]> playersOrder = new ArrayList<String[]>();
        for (List strings : roundOrder.values()) {
            playersOrder.add(0, strings.toArray(new String[strings.size()]));
        }
        return playersOrder;
    }

    public static RoundResults createRoundResults(Map<String, Integer> playerPoints, final Map<String, Double> playerTagTimes) {
        ArrayList<String> order = new ArrayList<String>(playerTagTimes.keySet());
        Collections.sort(order, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                double time2;
                double time1 = (Double)playerTagTimes.get(o1);
                if (time1 > (time2 = ((Double)playerTagTimes.get(o2)).doubleValue())) {
                    return -1;
                }
                if (time1 < time2) {
                    return 1;
                }
                return 0;
            }
        });
        HashMap<String, Integer> newPlayerPoints = new HashMap<String, Integer>();
        int points = 0;
        double previous = -1.0;
        for (String playerName : order) {
            double time = playerTagTimes.get(playerName);
            if (time < previous) {
                ++points;
            }
            previous = time;
            newPlayerPoints.put(playerName, points);
        }
        return new RoundResults(playerTagTimes, playerPoints, newPlayerPoints);
    }

    public Map<String, Double> getPlayerTagTimes() {
        return this.playerTagTimes;
    }

    public Map<String, Integer> getOldPlayerPoints() {
        return this.oldPlayerPoints;
    }

    public Map<String, Integer> getAddedPlayerPoints() {
        return this.addedPlayerPoints;
    }

    public List<String[]> getCurrentRoundPlayersOrder() {
        return this.currentRoundPlayersOrder;
    }

    public List<String[]> getAllRoundsOldPlayersOrder() {
        return this.allRoundsOldPlayersOrder;
    }

    public List<String[]> getAllRoundsNewPlayersOrder() {
        return this.allRoundsNewPlayersOrder;
    }
}

