/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.states.match;

import java.util.ArrayList;
import java.util.List;
import lonelycoders.ufohippa.client.InputListener;
import lonelycoders.ufohippa.client.Match;
import lonelycoders.ufohippa.game.PlayerInputAction;
import lonelycoders.ufohippa.network.CommandHandler;
import lonelycoders.ufohippa.network.CommandState;
import lonelycoders.ufohippa.network.State;
import lonelycoders.ufohippa.network.commands.match.ClientDroppedCommand;
import lonelycoders.ufohippa.network.commands.match.ContinueCommand;
import lonelycoders.ufohippa.network.commands.match.ContinueReplyCommand;
import lonelycoders.ufohippa.network.commands.match.MatchEndedCommand;
import lonelycoders.ufohippa.network.commands.match.RoundResultsCommand;
import lonelycoders.ufohippa.network.commands.match.RoundUpdateCommand;

public class ClientResultsState
extends CommandState
implements InputListener {
    private final List<Listener> listeners = new ArrayList<Listener>();
    private State nextState;
    private final State backToLobbyState;
    private Match match;
    private final CommandHandler roundUpdateHandler = new RoundUpdateCommand.Handler(){

        @Override
        public State process(RoundUpdateCommand payload) {
            return null;
        }
    };
    private final CommandHandler roundResultsHandler = new RoundResultsCommand.Handler(){

        @Override
        public State process(RoundResultsCommand payload) {
            ClientResultsState.this.match.showResults(payload.getRoundResults());
            return null;
        }
    };
    private CommandHandler continueReplyHandler = new ContinueReplyCommand.Handler(){

        @Override
        public State process(ContinueReplyCommand payload) {
            return ClientResultsState.this.nextState;
        }
    };
    private CommandHandler matchEndedHandler = new MatchEndedCommand.Handler(){

        @Override
        public State process(MatchEndedCommand payload) {
            ClientResultsState.this.notifyMatchEnded();
            return ClientResultsState.this.backToLobbyState;
        }
    };
    private final CommandHandler dropHandler = new ClientDroppedCommand.Handler(){

        @Override
        public State process(ClientDroppedCommand payload) {
            for (String playerName : payload.getPlayerNames()) {
                ClientResultsState.this.match.getPlayers().remove(playerName);
            }
            return null;
        }
    };

    public ClientResultsState(State backToLobbyState) {
        super("Results", new CommandHandler[0]);
        this.backToLobbyState = backToLobbyState;
        this.registerHandlers(this.roundResultsHandler, this.continueReplyHandler, this.matchEndedHandler, this.dropHandler, this.roundUpdateHandler);
    }

    public void setRoundState(State nextState) {
        this.nextState = nextState;
    }

    public void setMatch(Match match) {
        this.match = match;
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
    }

    @Override
    public void setInputActionState(PlayerInputAction action, boolean pressed) {
    }

    @Override
    public void continuePressed() {
        boolean shouldContinue;
        if (this.isActiveState() && (shouldContinue = this.match.nextResults())) {
            this.sendCommand(new ContinueCommand());
        }
    }

    public void notifyMatchEnded() {
        for (Listener listener : this.listeners) {
            listener.matchEnded();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void matchEnded();
    }
}

